/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.partition;

import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import com.oceanbase.tools.loaddump.partition.AbstractPartitionHelper;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OraclePartitionHelper
extends AbstractPartitionHelper {
    private static final Logger log = LoggerFactory.getLogger(OraclePartitionHelper.class);
    static final String QUERY_TABLE_PARTITIONS_LEVEL_ORACLE_1 = "SELECT TABLE_NAME AS TABLE_ID, (CASE WHEN DEF_SUBPARTITION_COUNT>1 THEN 2 ELSE 1 END) AS PART_LEVEL  FROM SYS.ALL_PART_TABLES WHERE TABLE_NAME=? AND OWNER=?";
    static final String QUERY_TABLE_PARTITIONS_LEVEL_ORACLE_2 = "SELECT T.TABLE_NAME AS TABLE_ID,T.PART_LEVEL FROM SYS.ALL_VIRTUAL_TABLE_REAL_AGENT T,SYS.ALL_USERS U WHERE T.TABLE_NAME=? AND U.USERNAME=? AND  T.DATABASE_ID=U.USERID";
    static final String QUERY_TABLE_PARTITIONS_ORACLE = "SELECT PARTITION_NAME AS PART_NAME FROM SYS.ALL_TAB_PARTITIONS WHERE TABLE_NAME=? AND TABLE_OWNER=?";
    static final String QUERY_TABLE_SUB_PARTITIONS_ORACLE = "SELECT SUBPARTITION_NAME AS PART_NAME FROM SYS.ALL_TAB_SUBPARTITIONS WHERE TABLE_NAME=? AND TABLE_OWNER=?";
    static final String QUERY_ALL_PARTITION_NAMES = "SELECT p.PARTITION_NAME AS PART_NAME, sp.SUBPARTITION_NAME AS SUB_PART_NAME FROM SYS.ALL_TAB_PARTITIONS p LEFT JOIN SYS.ALL_TAB_SUBPARTITIONS sp ON p.PARTITION_NAME = sp.PARTITION_NAME AND p.TABLE_NAME = sp.TABLE_NAME AND p.TABLE_OWNER = sp.TABLE_OWNER WHERE p.TABLE_NAME = ? AND p.TABLE_OWNER = ?";

    public OraclePartitionHelper(ConnectionKey connectionKey) {
        super(connectionKey);
    }

    @Override
    protected Map<String, Set<String>> queryPartMap(String tableId) throws Exception {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            Map<String, Set<String>> map = JdbcExecutor.queryMap(conn, QUERY_ALL_PARTITION_NAMES, new Object[]{tableId, this.connectionKey.getDatabase()}, rs -> {
                HashMap<String, Set> m = new HashMap<String, Set>();
                while (rs.next()) {
                    String partName = rs.getString("PART_NAME");
                    String subPartName = rs.getString("SUB_PART_NAME");
                    Set subParts = m.computeIfAbsent(partName, t -> Sets.newHashSet());
                    if (subPartName == null) continue;
                    subParts.add(subPartName);
                }
                return m;
            });
            return map;
        }
    }

    @Override
    protected String getQueryPartitionLevelSql() {
        return this.serverMode.isPreviousV2270() ? QUERY_TABLE_PARTITIONS_LEVEL_ORACLE_1 : QUERY_TABLE_PARTITIONS_LEVEL_ORACLE_2;
    }

    @Override
    protected String getQueryTablePartitionsSql(int partLevel) {
        return partLevel == 1 ? QUERY_TABLE_PARTITIONS_ORACLE : QUERY_TABLE_SUB_PARTITIONS_ORACLE;
    }

    public OraclePartitionHelper() {
    }
}

