/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.local;

import com.oceanbase.tools.loaddump.io.BoundedRandomInputStream;
import com.oceanbase.tools.loaddump.resource.AbstractResource;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Locale;
import org.apache.commons.io.input.BOMInputStream;

public class LocalResource
extends AbstractResource {
    private static final long serialVersionUID = 3774352250169708356L;
    private String path;

    public LocalResource(String objectType, String objectName, String path, long totalSize) {
        super(objectType, objectName, totalSize);
        this.path = path;
    }

    @Override
    public String getResourcePath() {
        return this.path;
    }

    @Override
    public InputStream openInputStream(String fileEncoding) throws Exception {
        return this.openBoundedInputStream(fileEncoding, 0L, this.totalSize);
    }

    @Override
    public InputStream openBoundedInputStream(String fileEncoding, long start, long end) throws Exception {
        RandomAccessFile raf = new RandomAccessFile(this.getResourcePath(), "r");
        raf.seek(start);
        BoundedRandomInputStream is = new BoundedRandomInputStream(raf, end);
        is.setPropagateClose(false);
        if (fileEncoding != null && fileEncoding.toLowerCase(Locale.ENGLISH).startsWith("utf")) {
            return new BOMInputStream((InputStream)is);
        }
        return is;
    }

    public LocalResource() {
    }
}

