/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.remote.hdfs;

import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.storage.remote.hdfs.HdfsStorageConfig;
import com.oceanbase.tools.loaddump.resource.remote.AbstractFileUploader;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsFileUploader
extends AbstractFileUploader {
    private static final Logger log = LoggerFactory.getLogger(HdfsFileUploader.class);
    HdfsStorageConfig config;
    FileSystem fs;

    public HdfsFileUploader(HdfsStorageConfig config, String filePath) {
        super(filePath);
        this.config = config;
        this.fs = config.createHdfsSystem();
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.HADOOP_HDFS;
    }

    @Override
    public String getDestUri() {
        return null;
    }

    @Override
    public void upload(File file) throws Exception {
        int bytesRead;
        String dest = this.config.assembleDestPath(file);
        FSDataOutputStream os = this.fs.create(new Path(dest));
        FileInputStream is = new FileInputStream(file);
        byte[] buffer = new byte[4096];
        while ((bytesRead = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
        log.info("Upload \"{}\" succeed.", (Object)file.getAbsolutePath());
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            log.warn("Failed to delete local file \"{}\". Error: {}", (Object)file, (Object)e.getMessage());
        }
        os.close();
        is.close();
    }

    @Override
    public void upload(File file, Object progressListener) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void close() {
        try {
            this.fs.close();
            this.fs = null;
        }
        catch (IOException e) {
            log.warn("Failed to close hadoop FileSystem. Reason: {}", (Object)e.getMessage());
        }
    }
}

