/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.remote.hdfs;

import com.oceanbase.tools.loaddump.common.model.storage.remote.hdfs.HdfsStorageConfig;
import com.oceanbase.tools.loaddump.resource.AbstractResource;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsResource
extends AbstractResource {
    private static final long serialVersionUID = 5226862804385487671L;
    private transient FileSystem fs;
    private String path;
    private HdfsStorageConfig config;

    public HdfsResource(HdfsStorageConfig config, String objectType, String objectName, String path, long totalSize) {
        super(objectType, objectName, totalSize);
        this.config = config;
        this.path = path;
        this.fs = config.createHdfsSystem();
    }

    @Override
    public String getResourcePath() {
        return this.path;
    }

    @Override
    public InputStream openInputStream(String fileEncoding) throws Exception {
        return this.openBoundedInputStream(fileEncoding, 0L, this.totalSize);
    }

    @Override
    public InputStream openBoundedInputStream(String fileEncoding, long start, long end) throws Exception {
        if (this.fs == null) {
            this.fs = this.config.createHdfsSystem();
        }
        LogUtils.info("Opening file: " + this.path);
        FSDataInputStream is = this.fs.open(new Path(this.path));
        is.seek(start);
        BoundedInputStream bis = new BoundedInputStream((InputStream)is);
        bis.setPropagateClose(false);
        if (fileEncoding != null && fileEncoding.toLowerCase(Locale.ENGLISH).startsWith("utf")) {
            return new BOMInputStream((InputStream)bis);
        }
        return bis;
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.fs != null) {
            this.fs.close();
        }
    }
}

