/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.remote.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.model.UploadFileRequest;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.factory.ObjectStorageClientFactory;
import com.oceanbase.tools.loaddump.resource.remote.AbstractFileUploader;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssFileUploader
extends AbstractFileUploader {
    private static final Logger log = LoggerFactory.getLogger(OssFileUploader.class);
    private final OssStorageConfig config;
    private OSS client;

    public OssFileUploader(OssStorageConfig config, String filePath) {
        super(filePath);
        this.config = config;
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.ALIYUN_OSS;
    }

    @Override
    public String getDestUri() {
        return this.config.getUri();
    }

    @Override
    public void upload(File file) throws Exception {
        if (this.client == null) {
            this.client = ObjectStorageClientFactory.createOssClient(this.config);
        }
        this.upload(file, null);
    }

    @Override
    public void upload(File file, Object progressListener) throws Exception {
        String objectKey = this.config.assembleDestPath(file);
        UploadFileRequest uploadFileRequest = new UploadFileRequest(this.config.getBucket(), objectKey);
        uploadFileRequest.setUploadFile(file.getAbsolutePath());
        uploadFileRequest.setPartSize(0x100000L);
        if (progressListener instanceof ProgressListener) {
            uploadFileRequest.setProgressListener((ProgressListener)progressListener);
        }
        try {
            this.client.uploadFile(uploadFileRequest);
            log.info("Upload \"{}\" succeed.", (Object)file.getAbsolutePath());
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                log.warn("Failed to delete local file \"{}\". Error: {}", (Object)file, (Object)e.getMessage());
            }
        }
        catch (Throwable e) {
            log.error("Upload \"{}\" failed, local file will not be deleted. Error: {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
            throw new IOException(e);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.shutdown();
        }
    }
}

