/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource.remote.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.S3StorageConfig;
import com.oceanbase.tools.loaddump.factory.ObjectStorageClientFactory;
import com.oceanbase.tools.loaddump.resource.AbstractResource;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.input.BOMInputStream;

public class S3Resource
extends AbstractResource {
    private static final long serialVersionUID = -8163481446784226142L;
    private final transient AmazonS3 client;
    private final String objectKey;
    private final S3StorageConfig config;

    public S3Resource(S3StorageConfig config, String objectType, String objectName, String objectKey, long totalSize) {
        super(objectType, objectName, totalSize);
        this.config = config;
        this.objectKey = objectKey;
        this.client = ObjectStorageClientFactory.createS3Client(config);
    }

    @Override
    public String getResourcePath() {
        return FileUtils.toPath(this.config.getBucket(), this.objectKey);
    }

    @Override
    public InputStream openInputStream(String fileEncoding) throws Exception {
        S3ObjectInputStream is = this.client.getObject(this.config.getBucket(), this.objectKey).getObjectContent();
        if (fileEncoding != null && fileEncoding.toLowerCase(Locale.ENGLISH).startsWith("utf")) {
            return new BOMInputStream((InputStream)is);
        }
        return is;
    }

    @Override
    public InputStream openBoundedInputStream(String fileEncoding, long start, long end) throws Exception {
        GetObjectRequest request = new GetObjectRequest(this.config.getBucket(), this.objectKey);
        request.setRange(start, end);
        S3ObjectInputStream is = this.client.getObject(request).getObjectContent();
        if (fileEncoding != null && fileEncoding.toLowerCase(Locale.ENGLISH).startsWith("utf")) {
            return new BOMInputStream((InputStream)is);
        }
        return is;
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.client != null) {
            this.client.shutdown();
        }
    }
}

