/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.ringbuffer;

import com.lmax.disruptor.ExceptionHandler;
import com.oceanbase.tools.loaddump.common.model.Insertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jExceptionHandler
implements ExceptionHandler<Insertion> {
    private static final Logger log = LoggerFactory.getLogger(Slf4jExceptionHandler.class);

    public void handleOnStartException(Throwable ex) {
        if (ex instanceof InterruptedException) {
            log.info("Ring buffer handler is interrupted on startup");
        } else {
            log.error("Fatal error occurred on startup", ex);
        }
    }

    public void handleOnShutdownException(Throwable ex) {
        if (ex instanceof InterruptedException) {
            log.info("Ring buffer handler is interrupted on shutdown");
        } else {
            log.error("Fatal error occurred on shutdown", ex);
        }
    }

    public void handleEventException(Throwable ex, long sequence, Insertion insertion) {
        if (ex instanceof InterruptedException) {
            log.info("Ring buffer handler is interrupted on handling events");
        } else {
            log.error("Fatal error occurred on handle. Sequence: {}", (Object)sequence, (Object)ex);
        }
    }
}

