/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.oceanbase.tools.loaddump.schema.AbstractOwnership;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.base.IGrammar;
import java.util.Objects;

public abstract class AbstractColumn
extends AbstractOwnership
implements IGrammar {
    private String columnName;
    private String dataType;
    private long ordinalPosition;
    private String columnDefault;
    private String nullable;
    private String columnComment;

    public AbstractColumn(AbstractSchema schema) {
        super(schema);
    }

    public String getWrappedName() {
        return this.wrap(this.getColumnName());
    }

    public String escapeColumnDefault(String colDefault) {
        if (colDefault.startsWith("'") && colDefault.endsWith("'") && colDefault.length() > 1) {
            colDefault = colDefault.substring(1, colDefault.length() - 1).replace("'", "''");
            return "'" + colDefault + "'";
        }
        return colDefault;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columnName, this.ordinalPosition);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractColumn)) {
            return false;
        }
        AbstractColumn other = (AbstractColumn)obj;
        return Objects.equals(this.columnName, other.columnName) && Objects.equals(this.ordinalPosition, other.ordinalPosition);
    }

    public AbstractColumn() {
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public long getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setOrdinalPosition(long ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    public String getColumnDefault() {
        return this.columnDefault;
    }

    public void setColumnDefault(String columnDefault) {
        this.columnDefault = columnDefault;
    }

    public String getNullable() {
        return this.nullable;
    }

    public void setNullable(String nullable) {
        this.nullable = nullable;
    }

    public String getColumnComment() {
        return this.columnComment;
    }

    public void setColumnComment(String columnComment) {
        this.columnComment = columnComment;
    }
}

