/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractOwnership;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.base.IDefiner;
import com.oceanbase.tools.loaddump.schema.base.IDelimiter;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import java.util.List;

public abstract class AbstractProcedure
extends AbstractOwnership
implements IDefiner,
IDelimiter {
    private boolean fullText;
    private String text;

    public AbstractProcedure(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if (!this.isFullText()) {
            sb.append("CREATE OR REPLACE ");
        }
        sb.append(this.getText());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.PROCEDURE, this.getSimpleObjectName(), this.terminate(sb))});
    }

    public AbstractProcedure() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractProcedure)) {
            return false;
        }
        AbstractProcedure other = (AbstractProcedure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isFullText() != other.isFullText()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractProcedure;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isFullText() ? 79 : 97);
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public boolean isFullText() {
        return this.fullText;
    }

    public void setFullText(boolean fullText) {
        this.fullText = fullText;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

