/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.thirdparty.com.google.common.graph.ElementOrder;
import org.apache.hadoop.thirdparty.com.google.common.graph.Graph;
import org.apache.hadoop.thirdparty.com.google.common.graph.GraphBuilder;
import org.apache.hadoop.thirdparty.com.google.common.graph.Graphs;
import org.apache.hadoop.thirdparty.com.google.common.graph.MutableGraph;
import org.apache.hadoop.thirdparty.com.google.common.graph.Traverser;

public class ObjectRelationGraph {
    private MutableGraph<String> graph;

    public ObjectRelationGraph(int nodeCount) {
        this.graph = GraphBuilder.directed().allowsSelfLoops(true).expectedNodeCount(nodeCount).nodeOrder(ElementOrder.insertion()).build();
    }

    public boolean add(Object predecessor, Object successor) {
        return this.graph.putEdge((Object)predecessor.toString(), (Object)successor.toString());
    }

    public boolean hasCycle() {
        return Graphs.hasCycle(this.graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findCyclePath() {
        if (!this.hasCycle()) {
            return new String("No cycle reference were found");
        }
        Set nodes = this.graph.nodes();
        LinkedList<LinkedList<String>> cycleList = new LinkedList<LinkedList<String>>();
        LinkedHashMap<Object, NodeVisitState> visitedNodes = new LinkedHashMap<Object, NodeVisitState>(nodes.size());
        String previousNode = null;
        LinkedList<String> subCycleList = null;
        try {
            for (String node : nodes) {
                NodeVisitState state = (NodeVisitState)((Object)visitedNodes.get(node));
                if (state == NodeVisitState.PENDING) {
                    this.subgraphCyclePath((Graph<String>)this.graph, (Map<Object, NodeVisitState>)visitedNodes, node, previousNode, subCycleList);
                    continue;
                }
                subCycleList = new LinkedList<String>();
                this.subgraphCyclePath((Graph<String>)this.graph, (Map<Object, NodeVisitState>)visitedNodes, node, null, subCycleList);
                cycleList.add(subCycleList);
                previousNode = node;
            }
        }
        finally {
            visitedNodes.clear();
        }
        AtomicInteger index = new AtomicInteger(1);
        return cycleList.stream().filter(e -> !e.isEmpty()).map(e -> "Cycle-" + index.getAndIncrement() + ": " + e.stream().collect(Collectors.joining(" -> "))).collect(Collectors.joining("\n"));
    }

    public List<String> visitDepthFirst() {
        Set nodes = this.graph.nodes();
        LinkedHashSet sorted = new LinkedHashSet();
        Traverser traverser = Traverser.forGraph(this.graph);
        for (String node : nodes) {
            if (this.graph.inDegree((Object)node) > this.graph.outDegree((Object)node)) continue;
            Iterable iterable = traverser.depthFirstPostOrder((Object)node);
            Iterator iter = iterable.iterator();
            while (iter.hasNext()) {
                sorted.add(iter.next());
            }
        }
        return Lists.newArrayList(sorted);
    }

    public List<ObjectDefine> sortByDepthFirst(final List<ObjectDefine> objectDefines) {
        if (CollectionUtils.isEmpty(objectDefines)) {
            return objectDefines;
        }
        final List<String> sorted = this.visitDepthFirst();
        Collections.sort(objectDefines, new Comparator<ObjectDefine>(){

            @Override
            public int compare(ObjectDefine o1, ObjectDefine o2) {
                int idx1 = sorted.indexOf(o1.getCoordinate());
                int idx2 = sorted.indexOf(o2.getCoordinate());
                if (idx1 != -1) {
                    idx1 = objectDefines.size() - idx1;
                }
                if (idx2 != -1) {
                    idx2 = objectDefines.size() - idx2;
                }
                return idx2 - idx1;
            }
        });
        return objectDefines;
    }

    public List<ObjectDefine> groupByDepthFirst(List<ObjectDefine> objectDefines) {
        if (CollectionUtils.isEmpty(objectDefines)) {
            return objectDefines;
        }
        HashMap<String, ObjectDefine> edgeMap = new HashMap<String, ObjectDefine>(16);
        for (ObjectDefine objectDefine : objectDefines) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(objectDefine.getObjectType());
            sb.append("]");
            sb.append(objectDefine.getObjectName());
            edgeMap.putIfAbsent(sb.toString(), objectDefine);
        }
        Set nodes = this.graph.nodes();
        Traverser traverser = Traverser.forGraph(this.graph);
        HashMap<String, String> groupMap = new HashMap<String, String>(16);
        for (String node : nodes) {
            if (this.graph.inDegree((Object)node) > this.graph.outDegree((Object)node)) continue;
            int sequenceId = 0;
            String groupId = UUID.randomUUID().toString();
            Iterable iterable = traverser.depthFirstPostOrder((Object)node);
            for (String temp : iterable) {
                ObjectDefine objectDefine;
                groupMap.putIfAbsent(temp, groupId);
                if (groupMap.containsKey(temp)) {
                    groupId = (String)groupMap.get(temp);
                }
                if ((objectDefine = (ObjectDefine)edgeMap.get(temp)) == null) continue;
                objectDefine.setGroupId(groupId);
                objectDefine.setSequenceId(sequenceId++);
            }
        }
        return Lists.newArrayList(edgeMap.values());
    }

    private boolean subgraphCyclePath(Graph<String> graph, Map<Object, NodeVisitState> visitedNodes, String node, String previousNode, LinkedList<String> cycleList) {
        NodeVisitState state = visitedNodes.get(node);
        if (state == NodeVisitState.COMPLETE) {
            return false;
        }
        if (state == NodeVisitState.PENDING) {
            if (previousNode != null && node != null) {
                cycleList.add(node);
            }
            return true;
        }
        visitedNodes.put(node, NodeVisitState.PENDING);
        for (String nextNode : graph.predecessors((Object)node)) {
            boolean foundJoinNode = Objects.equals(previousNode, nextNode);
            if (!foundJoinNode && (foundJoinNode || !this.subgraphCyclePath(graph, visitedNodes, nextNode, node, cycleList))) continue;
            if (graph.inDegree((Object)node) > 0) {
                cycleList.add(node);
            }
            return true;
        }
        visitedNodes.put(node, NodeVisitState.COMPLETE);
        return false;
    }

    public ObjectRelationGraph() {
    }

    private static enum NodeVisitState {
        PENDING,
        COMPLETE;

    }
}

