/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.AbstractTablePartition;
import com.oceanbase.tools.loaddump.schema.TableGroupSubPartition;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleTablePartition;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class TableGroupPartition
extends AbstractTablePartition {
    private final Collection<ObOracleTablePartition.OracleTablePartitionItem> partitionItems = new LinkedHashSet<ObOracleTablePartition.OracleTablePartitionItem>();
    private String partitionType;
    private int partitionColumnNum;
    private int partitionCount;
    private TableGroupSubPartition tableGroupSubPartition;

    public TableGroupPartition(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        TableGroupSubPartition subPartition;
        if (!this.isValid()) {
            return new StringBuilder(0);
        }
        this.resolvePartType(this);
        String partType = this.getPartitionType();
        StringBuilder sb = new StringBuilder(512);
        sb.append("\nPARTITION BY ").append(partType);
        boolean isKey = "KEY".equals(partType);
        boolean isListColumns = "LIST COLUMNS".equals(partType);
        boolean isRangeColumns = "RANGE COLUMNS".equals(partType);
        if (isKey || isListColumns || isRangeColumns) {
            sb.append(" ").append(this.getPartitionColumnNum());
        }
        if ((subPartition = this.getTableGroupSubPartition()) == null || !subPartition.isValid()) {
            return sb.append((CharSequence)this.buildPartitionDescription());
        }
        this.resolvePartType(subPartition);
        sb.append("\nSUBPARTITION BY ").append(subPartition.getSubPartitionType());
        if (this.getTableGroupSubPartition().isDefinedByTemplate()) {
            return sb.append((CharSequence)this.buildSubPartitionWithinTemplate());
        }
        return sb.append((CharSequence)this.buildSubPartitionWithoutTemplate());
    }

    private void resolvePartType(AbstractTablePartition partition) {
        if (DbType.OBORACLE_21.getType().equals(this.getDbType().getType())) {
            if (partition instanceof TableGroupPartition) {
                TableGroupPartition part = (TableGroupPartition)partition;
                if ("LIST".equals(part.getPartitionType())) {
                    part.setPartitionType("LIST COLUMNS");
                } else if ("RANGE".equals(part.getPartitionType())) {
                    part.setPartitionType("RANGE COLUMNS");
                }
            } else if (partition instanceof TableGroupSubPartition) {
                TableGroupSubPartition subPart = (TableGroupSubPartition)partition;
                if ("LIST".equals(subPart.getSubPartitionType())) {
                    subPart.setSubPartitionType("LIST COLUMNS");
                } else if ("RANGE".equals(subPart.getSubPartitionType())) {
                    subPart.setSubPartitionType("RANGE COLUMNS");
                }
            }
        }
    }

    private StringBuilder buildPartitionDescription() {
        String partType = this.getPartitionType();
        boolean isKey = "KEY".equals(partType);
        boolean isHash = "HASH".equals(partType);
        StringBuilder sb = new StringBuilder(512);
        if (isKey || isHash) {
            sb.append("\nPARTITIONS ").append(this.getPartitionCount());
        }
        boolean isList = "LIST".equals(partType);
        boolean isRange = "RANGE".equals(partType);
        boolean isListColumns = "LIST COLUMNS".equals(partType);
        boolean isRangeColumns = "RANGE COLUMNS".equals(partType);
        if (isList || isListColumns || isRange || isRangeColumns) {
            String partFormat = this.getPartFormat();
            sb.append("\n(");
            Iterator<ObOracleTablePartition.OracleTablePartitionItem> iter = this.getPartitionItems().iterator();
            while (iter.hasNext()) {
                sb.append("\n\t");
                ObOracleTablePartition.OracleTablePartitionItem partItem = iter.next();
                String partName = this.wrap(partItem.getPartitionName());
                sb.append(String.format(partFormat, partName, partItem.getHighValue()));
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append("\n)");
        }
        return sb;
    }

    private StringBuilder buildSubPartitionWithinTemplate() throws UnsupportedGrammarException {
        TableGroupSubPartition subPartition = this.getTableGroupSubPartition();
        String subPartType = subPartition.getSubPartitionType();
        StringBuilder sb = new StringBuilder(512);
        boolean isKey = "KEY".equals(subPartType);
        boolean isHash = "HASH".equals(subPartType);
        boolean isListColumns = "LIST COLUMNS".equals(subPartType);
        boolean isRangeColumns = "RANGE COLUMNS".equals(subPartType);
        if (isKey || isListColumns || isRangeColumns || this.isNewFeatureFrom32x()) {
            sb.append(" ").append(subPartition.getSubPartitionColumnNum());
        }
        if (isKey || isHash) {
            sb.append(" SUBPARTITIONS ").append(subPartition.getSubPartitionCount());
        } else {
            sb.append((CharSequence)subPartition.buildGrammar());
        }
        return sb.append((CharSequence)this.buildPartitionDescription());
    }

    private StringBuilder buildSubPartitionWithoutTemplate() throws UnsupportedGrammarException {
        TableGroupSubPartition subPartition = this.getTableGroupSubPartition();
        String subPartType = subPartition.getSubPartitionType();
        StringBuilder sb = new StringBuilder(512);
        boolean isKey = "KEY".equals(subPartType);
        boolean isListColumns = "LIST COLUMNS".equals(subPartType);
        boolean isRangeColumns = "RANGE COLUMNS".equals(subPartType);
        if (isKey || isListColumns || isRangeColumns || this.isNewFeatureFrom32x()) {
            sb.append(" ").append(subPartition.getSubPartitionColumnNum());
        }
        sb.append("\n(");
        String partFormat = this.getPartFormat();
        String subPartFormat = subPartition.getSubPartFormat();
        Map<Integer, List<ObOracleTablePartition.OracleTablePartitionItem>> map = subPartition.getSubPartitionItemMapping();
        Iterator<ObOracleTablePartition.OracleTablePartitionItem> iter = this.getPartitionItems().iterator();
        while (iter.hasNext()) {
            ObOracleTablePartition.OracleTablePartitionItem partItem = iter.next();
            String partName = this.wrap(partItem.getPartitionName());
            int partId = partItem.getPartitionPosition();
            sb.append("\n\t");
            sb.append(String.format(partFormat, partName, partItem.getHighValue()));
            sb.append("\n\t(");
            Iterator<ObOracleTablePartition.OracleTablePartitionItem> siter = map.get(partId).iterator();
            while (siter.hasNext()) {
                ObOracleTablePartition.OracleTablePartitionItem subPartItem = siter.next();
                String subPartName = this.wrap(subPartItem.getPartitionName());
                sb.append("\n\t\t");
                sb.append(String.format(subPartFormat, subPartName, partItem.getHighValue()));
                if (!siter.hasNext()) continue;
                sb.append(",");
            }
            sb.append("\n\t)");
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n)");
    }

    @Override
    public String getQuotaCharacter() {
        DbType dbType = super.getDbType();
        if (dbType != null && dbType.isMySqlType()) {
            return "`";
        }
        return super.getQuotaCharacter();
    }

    public boolean isValid() {
        return this.getPartitionColumnNum() > 0;
    }

    public boolean isNewFeatureFrom32x() {
        boolean isNewFeature;
        TableGroupSubPartition subPartition = this.getTableGroupSubPartition();
        isNewFeature &= (isNewFeature = DbType.OBORACLE_322.getType().equals(this.getDbType().getType())) && DbType.OBORACLE_322.isPriorFrom(this.getDbType());
        return (isNewFeature &= "HASH".equals(subPartition.getSubPartitionType())) && !subPartition.isDefinedByTemplate();
    }

    public String getJdbcFieldName() {
        if ("LIST".equals(this.getPartitionType()) || "LIST COLUMNS".equals(this.getPartitionType())) {
            return "part_list_val";
        }
        return "part_high_bound_val";
    }

    public String getPartFormat() {
        if (DbType.OBMYSQL_14.getType().equals(this.getDbType().getType()) && "LIST".equals(this.getPartitionType())) {
            return super.getTablePartTemplateMapping().get("LIST COLUMNS");
        }
        if (DbType.OBORACLE_21.getType().equals(this.getDbType().getType()) && "LIST COLUMNS".equals(this.getPartitionType())) {
            return super.getTablePartTemplateMapping().get("LIST");
        }
        return super.getTablePartTemplateMapping().get(this.getPartitionType());
    }

    public TableGroupPartition() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableGroupPartition)) {
            return false;
        }
        TableGroupPartition other = (TableGroupPartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPartitionColumnNum() != other.getPartitionColumnNum()) {
            return false;
        }
        if (this.getPartitionCount() != other.getPartitionCount()) {
            return false;
        }
        Collection<ObOracleTablePartition.OracleTablePartitionItem> this$partitionItems = this.getPartitionItems();
        Collection<ObOracleTablePartition.OracleTablePartitionItem> other$partitionItems = other.getPartitionItems();
        if (this$partitionItems == null ? other$partitionItems != null : !((Object)this$partitionItems).equals(other$partitionItems)) {
            return false;
        }
        String this$partitionType = this.getPartitionType();
        String other$partitionType = other.getPartitionType();
        if (this$partitionType == null ? other$partitionType != null : !this$partitionType.equals(other$partitionType)) {
            return false;
        }
        TableGroupSubPartition this$tableGroupSubPartition = this.getTableGroupSubPartition();
        TableGroupSubPartition other$tableGroupSubPartition = other.getTableGroupSubPartition();
        return !(this$tableGroupSubPartition == null ? other$tableGroupSubPartition != null : !((Object)this$tableGroupSubPartition).equals(other$tableGroupSubPartition));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableGroupPartition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPartitionColumnNum();
        result = result * 59 + this.getPartitionCount();
        Collection<ObOracleTablePartition.OracleTablePartitionItem> $partitionItems = this.getPartitionItems();
        result = result * 59 + ($partitionItems == null ? 43 : ((Object)$partitionItems).hashCode());
        String $partitionType = this.getPartitionType();
        result = result * 59 + ($partitionType == null ? 43 : $partitionType.hashCode());
        TableGroupSubPartition $tableGroupSubPartition = this.getTableGroupSubPartition();
        result = result * 59 + ($tableGroupSubPartition == null ? 43 : ((Object)$tableGroupSubPartition).hashCode());
        return result;
    }

    public Collection<ObOracleTablePartition.OracleTablePartitionItem> getPartitionItems() {
        return this.partitionItems;
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public void setPartitionType(String partitionType) {
        this.partitionType = partitionType;
    }

    public int getPartitionColumnNum() {
        return this.partitionColumnNum;
    }

    public void setPartitionColumnNum(int partitionColumnNum) {
        this.partitionColumnNum = partitionColumnNum;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public TableGroupSubPartition getTableGroupSubPartition() {
        return this.tableGroupSubPartition;
    }

    public void setTableGroupSubPartition(TableGroupSubPartition tableGroupSubPartition) {
        this.tableGroupSubPartition = tableGroupSubPartition;
    }
}

