/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractTable;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.obmysql.AbstractObMySqlConstraint;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlCheck;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlColumn;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlForeignKey;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlIndex;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlPrimaryKey;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlTablePartition;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlUniqueKey;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class ObMySqlTable
extends AbstractTable {
    private final Map<String, ObMySqlColumn> columnMapping = new LinkedHashMap<String, ObMySqlColumn>();
    private final Map<String, ObMySqlIndex> indexMapping = new LinkedHashMap<String, ObMySqlIndex>();
    private final Map<String, ObMySqlCheck> checkMapping = new LinkedHashMap<String, ObMySqlCheck>();
    private final Map<String, ObMySqlUniqueKey> uniqueMapping = new LinkedHashMap<String, ObMySqlUniqueKey>();
    private final Map<String, ObMySqlForeignKey> foreignMapping = new LinkedHashMap<String, ObMySqlForeignKey>();
    private String engine;
    private String version;
    private String rowFormat;
    private String tableRows;
    private String avgRowLength;
    private String dataLength;
    private String maxDataLength;
    private String indexLength;
    private String dataFree;
    private Long autoIncrement;
    private String createTime;
    private String updateTime;
    private String checkTime;
    private String checksum;
    private String createOptions;
    private String tableCollation;
    private String characterSetName;
    private String visible;
    private String tableGroupName;
    private ObMySqlPrimaryKey primaryKey;
    private ObMySqlTablePartition tablePartition;

    public ObMySqlTable(ObMySqlSchema schema) {
        super(schema);
    }

    @Override
    public ObMySqlSchema getSchema() {
        return (ObMySqlSchema)super.getSchema();
    }

    public void setSchema(ObMySqlSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        String objectName = this.getSchemaObjectName();
        sb.append("create table if not exists ").append(objectName).append(" (");
        Collection<ObMySqlColumn> columns = this.getColumnMapping().values();
        Iterator<ObMySqlColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            Iterator<AbstractObMySqlConstraint> charsetName;
            ObMySqlColumn column = iter.next();
            String tableCollation = this.getTableCollation();
            if (tableCollation != null && tableCollation.equals(column.getCollationName())) {
                column.setCollationName(null);
            }
            if ((charsetName = this.getCharacterSetName()) != null && ((String)((Object)charsetName)).equals(column.getCharacterSetName())) {
                column.setCharacterSetName(null);
            }
            sb.append("\n\t").append((CharSequence)column.buildGrammar());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        ObMySqlPrimaryKey primaryKey = this.getPrimaryKey();
        ObMySqlTablePartition partition = this.getTablePartition();
        Map<String, ObMySqlUniqueKey> uniqueMapping = this.getUniqueMapping();
        if (primaryKey != null) {
            primaryKey.setColumnMapping(this.columnMapping);
            sb.append(",\n\t").append((CharSequence)primaryKey.buildGrammar());
        }
        if (MapUtils.isNotEmpty(this.getCheckMapping())) {
            for (ObMySqlCheck obMySqlCheck : this.getCheckMapping().values()) {
                sb.append(",\n\t").append((CharSequence)obMySqlCheck.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(uniqueMapping)) {
            for (ObMySqlUniqueKey obMySqlUniqueKey : uniqueMapping.values()) {
                ObMySqlIndex index = this.getIndexMapping().get(obMySqlUniqueKey.getConstraintName());
                if (index != null) {
                    obMySqlUniqueKey.setIndexType(index.getIndexType());
                }
                sb.append(",\n\t").append((CharSequence)obMySqlUniqueKey.buildGrammar());
            }
        }
        if (MapUtils.isNotEmpty(this.getForeignMapping())) {
            for (ObMySqlForeignKey obMySqlForeignKey : this.getForeignMapping().values()) {
                sb.append(",\n\t").append((CharSequence)obMySqlForeignKey.buildGrammar());
            }
        }
        sb.append("\n").append(")");
        sb.append((CharSequence)this.appendTableOptions());
        if (partition != null) {
            sb.append((CharSequence)partition.buildGrammar());
        }
        LinkedList<ObjectDefine> subDefines = new LinkedList<ObjectDefine>();
        if (MapUtils.isNotEmpty(this.getIndexMapping())) {
            for (ObMySqlIndex index : this.getIndexMapping().values()) {
                if (partition != null && this.getDbType().isPrior(DbType.OBMYSQL_200)) {
                    index.setLocality("LOCAL");
                }
                subDefines.addAll(index.buildDefinition());
            }
        }
        CreateObjectDefine createObjectDefine = new CreateObjectDefine(ObjectType.TABLE, this.getSimpleObjectName(), this.terminate(sb), subDefines);
        return Lists.newArrayList((Object[])new ObjectDefine[]{createObjectDefine});
    }

    protected StringBuilder appendTableOptions() throws UnsupportedGrammarException {
        String tableComment;
        Long autoIncrement;
        String originCollation;
        String originCharset = this.getCharacterSetName();
        if ("utf8".equalsIgnoreCase(originCharset)) {
            this.setCharacterSetName("utf8mb4");
        }
        if (StringUtils.startsWithIgnoreCase(originCollation = this.getTableCollation(), "utf8")) {
            String targetCollation = originCollation.replace("utf8_", "utf8mb4_");
            if (StringUtils.startsWithIgnoreCase(originCollation, "utf8mb4_") && StringUtils.endsWithIgnoreCase(originCollation, "_ai_ci")) {
                this.setTableCollation("utf8mb4_general_ci");
            } else {
                this.setTableCollation(targetCollation);
            }
        }
        String charsetName = this.getCharacterSetName();
        String tableCollation = this.getTableCollation();
        StringBuilder sb = new StringBuilder();
        String tableGroupName = this.getTableGroupName();
        if (StringUtils.isNotBlank(tableGroupName)) {
            sb.append("\n").append("tablegroup=").append(tableGroupName);
        }
        if ((autoIncrement = this.getAutoIncrement()) != null && autoIncrement > 0L) {
            sb.append("\n").append("auto_increment=").append(autoIncrement);
        }
        if (StringUtils.isNotBlank(charsetName)) {
            sb.append("\n").append("default charset=").append(charsetName);
        }
        if (StringUtils.isNotBlank(tableCollation) && !tableCollation.equals(charsetName)) {
            sb.append("\n").append("default collate=").append(tableCollation);
        }
        if (StringUtils.isNotBlank(tableComment = this.getTableComment())) {
            sb.append("\n").append("comment='").append(tableComment.replace("'", "''")).append("'");
        }
        return sb;
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    @Override
    public String toString() {
        return "ObMySqlTable(columnMapping=" + this.getColumnMapping() + ", indexMapping=" + this.getIndexMapping() + ", checkMapping=" + this.getCheckMapping() + ", uniqueMapping=" + this.getUniqueMapping() + ", foreignMapping=" + this.getForeignMapping() + ", engine=" + this.getEngine() + ", version=" + this.getVersion() + ", rowFormat=" + this.getRowFormat() + ", tableRows=" + this.getTableRows() + ", avgRowLength=" + this.getAvgRowLength() + ", dataLength=" + this.getDataLength() + ", maxDataLength=" + this.getMaxDataLength() + ", indexLength=" + this.getIndexLength() + ", dataFree=" + this.getDataFree() + ", autoIncrement=" + this.getAutoIncrement() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", checkTime=" + this.getCheckTime() + ", checksum=" + this.getChecksum() + ", createOptions=" + this.getCreateOptions() + ", tableCollation=" + this.getTableCollation() + ", characterSetName=" + this.getCharacterSetName() + ", visible=" + this.getVisible() + ", tableGroupName=" + this.getTableGroupName() + ", primaryKey=" + this.getPrimaryKey() + ", tablePartition=" + this.getTablePartition() + ")";
    }

    public ObMySqlTable() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObMySqlTable)) {
            return false;
        }
        ObMySqlTable other = (ObMySqlTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$autoIncrement = this.getAutoIncrement();
        Long other$autoIncrement = other.getAutoIncrement();
        if (this$autoIncrement == null ? other$autoIncrement != null : !((Object)this$autoIncrement).equals(other$autoIncrement)) {
            return false;
        }
        Map<String, ObMySqlColumn> this$columnMapping = this.getColumnMapping();
        Map<String, ObMySqlColumn> other$columnMapping = other.getColumnMapping();
        if (this$columnMapping == null ? other$columnMapping != null : !((Object)this$columnMapping).equals(other$columnMapping)) {
            return false;
        }
        Map<String, ObMySqlIndex> this$indexMapping = this.getIndexMapping();
        Map<String, ObMySqlIndex> other$indexMapping = other.getIndexMapping();
        if (this$indexMapping == null ? other$indexMapping != null : !((Object)this$indexMapping).equals(other$indexMapping)) {
            return false;
        }
        Map<String, ObMySqlCheck> this$checkMapping = this.getCheckMapping();
        Map<String, ObMySqlCheck> other$checkMapping = other.getCheckMapping();
        if (this$checkMapping == null ? other$checkMapping != null : !((Object)this$checkMapping).equals(other$checkMapping)) {
            return false;
        }
        Map<String, ObMySqlUniqueKey> this$uniqueMapping = this.getUniqueMapping();
        Map<String, ObMySqlUniqueKey> other$uniqueMapping = other.getUniqueMapping();
        if (this$uniqueMapping == null ? other$uniqueMapping != null : !((Object)this$uniqueMapping).equals(other$uniqueMapping)) {
            return false;
        }
        Map<String, ObMySqlForeignKey> this$foreignMapping = this.getForeignMapping();
        Map<String, ObMySqlForeignKey> other$foreignMapping = other.getForeignMapping();
        if (this$foreignMapping == null ? other$foreignMapping != null : !((Object)this$foreignMapping).equals(other$foreignMapping)) {
            return false;
        }
        String this$engine = this.getEngine();
        String other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$rowFormat = this.getRowFormat();
        String other$rowFormat = other.getRowFormat();
        if (this$rowFormat == null ? other$rowFormat != null : !this$rowFormat.equals(other$rowFormat)) {
            return false;
        }
        String this$tableRows = this.getTableRows();
        String other$tableRows = other.getTableRows();
        if (this$tableRows == null ? other$tableRows != null : !this$tableRows.equals(other$tableRows)) {
            return false;
        }
        String this$avgRowLength = this.getAvgRowLength();
        String other$avgRowLength = other.getAvgRowLength();
        if (this$avgRowLength == null ? other$avgRowLength != null : !this$avgRowLength.equals(other$avgRowLength)) {
            return false;
        }
        String this$dataLength = this.getDataLength();
        String other$dataLength = other.getDataLength();
        if (this$dataLength == null ? other$dataLength != null : !this$dataLength.equals(other$dataLength)) {
            return false;
        }
        String this$maxDataLength = this.getMaxDataLength();
        String other$maxDataLength = other.getMaxDataLength();
        if (this$maxDataLength == null ? other$maxDataLength != null : !this$maxDataLength.equals(other$maxDataLength)) {
            return false;
        }
        String this$indexLength = this.getIndexLength();
        String other$indexLength = other.getIndexLength();
        if (this$indexLength == null ? other$indexLength != null : !this$indexLength.equals(other$indexLength)) {
            return false;
        }
        String this$dataFree = this.getDataFree();
        String other$dataFree = other.getDataFree();
        if (this$dataFree == null ? other$dataFree != null : !this$dataFree.equals(other$dataFree)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        String this$checkTime = this.getCheckTime();
        String other$checkTime = other.getCheckTime();
        if (this$checkTime == null ? other$checkTime != null : !this$checkTime.equals(other$checkTime)) {
            return false;
        }
        String this$checksum = this.getChecksum();
        String other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
            return false;
        }
        String this$createOptions = this.getCreateOptions();
        String other$createOptions = other.getCreateOptions();
        if (this$createOptions == null ? other$createOptions != null : !this$createOptions.equals(other$createOptions)) {
            return false;
        }
        String this$tableCollation = this.getTableCollation();
        String other$tableCollation = other.getTableCollation();
        if (this$tableCollation == null ? other$tableCollation != null : !this$tableCollation.equals(other$tableCollation)) {
            return false;
        }
        String this$characterSetName = this.getCharacterSetName();
        String other$characterSetName = other.getCharacterSetName();
        if (this$characterSetName == null ? other$characterSetName != null : !this$characterSetName.equals(other$characterSetName)) {
            return false;
        }
        String this$visible = this.getVisible();
        String other$visible = other.getVisible();
        if (this$visible == null ? other$visible != null : !this$visible.equals(other$visible)) {
            return false;
        }
        String this$tableGroupName = this.getTableGroupName();
        String other$tableGroupName = other.getTableGroupName();
        if (this$tableGroupName == null ? other$tableGroupName != null : !this$tableGroupName.equals(other$tableGroupName)) {
            return false;
        }
        ObMySqlPrimaryKey this$primaryKey = this.getPrimaryKey();
        ObMySqlPrimaryKey other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !((Object)this$primaryKey).equals(other$primaryKey)) {
            return false;
        }
        ObMySqlTablePartition this$tablePartition = this.getTablePartition();
        ObMySqlTablePartition other$tablePartition = other.getTablePartition();
        return !(this$tablePartition == null ? other$tablePartition != null : !((Object)this$tablePartition).equals(other$tablePartition));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObMySqlTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $autoIncrement = this.getAutoIncrement();
        result = result * 59 + ($autoIncrement == null ? 43 : ((Object)$autoIncrement).hashCode());
        Map<String, ObMySqlColumn> $columnMapping = this.getColumnMapping();
        result = result * 59 + ($columnMapping == null ? 43 : ((Object)$columnMapping).hashCode());
        Map<String, ObMySqlIndex> $indexMapping = this.getIndexMapping();
        result = result * 59 + ($indexMapping == null ? 43 : ((Object)$indexMapping).hashCode());
        Map<String, ObMySqlCheck> $checkMapping = this.getCheckMapping();
        result = result * 59 + ($checkMapping == null ? 43 : ((Object)$checkMapping).hashCode());
        Map<String, ObMySqlUniqueKey> $uniqueMapping = this.getUniqueMapping();
        result = result * 59 + ($uniqueMapping == null ? 43 : ((Object)$uniqueMapping).hashCode());
        Map<String, ObMySqlForeignKey> $foreignMapping = this.getForeignMapping();
        result = result * 59 + ($foreignMapping == null ? 43 : ((Object)$foreignMapping).hashCode());
        String $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $rowFormat = this.getRowFormat();
        result = result * 59 + ($rowFormat == null ? 43 : $rowFormat.hashCode());
        String $tableRows = this.getTableRows();
        result = result * 59 + ($tableRows == null ? 43 : $tableRows.hashCode());
        String $avgRowLength = this.getAvgRowLength();
        result = result * 59 + ($avgRowLength == null ? 43 : $avgRowLength.hashCode());
        String $dataLength = this.getDataLength();
        result = result * 59 + ($dataLength == null ? 43 : $dataLength.hashCode());
        String $maxDataLength = this.getMaxDataLength();
        result = result * 59 + ($maxDataLength == null ? 43 : $maxDataLength.hashCode());
        String $indexLength = this.getIndexLength();
        result = result * 59 + ($indexLength == null ? 43 : $indexLength.hashCode());
        String $dataFree = this.getDataFree();
        result = result * 59 + ($dataFree == null ? 43 : $dataFree.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        String $checkTime = this.getCheckTime();
        result = result * 59 + ($checkTime == null ? 43 : $checkTime.hashCode());
        String $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
        String $createOptions = this.getCreateOptions();
        result = result * 59 + ($createOptions == null ? 43 : $createOptions.hashCode());
        String $tableCollation = this.getTableCollation();
        result = result * 59 + ($tableCollation == null ? 43 : $tableCollation.hashCode());
        String $characterSetName = this.getCharacterSetName();
        result = result * 59 + ($characterSetName == null ? 43 : $characterSetName.hashCode());
        String $visible = this.getVisible();
        result = result * 59 + ($visible == null ? 43 : $visible.hashCode());
        String $tableGroupName = this.getTableGroupName();
        result = result * 59 + ($tableGroupName == null ? 43 : $tableGroupName.hashCode());
        ObMySqlPrimaryKey $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : ((Object)$primaryKey).hashCode());
        ObMySqlTablePartition $tablePartition = this.getTablePartition();
        result = result * 59 + ($tablePartition == null ? 43 : ((Object)$tablePartition).hashCode());
        return result;
    }

    public Map<String, ObMySqlColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, ObMySqlIndex> getIndexMapping() {
        return this.indexMapping;
    }

    public Map<String, ObMySqlCheck> getCheckMapping() {
        return this.checkMapping;
    }

    public Map<String, ObMySqlUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Map<String, ObMySqlForeignKey> getForeignMapping() {
        return this.foreignMapping;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRowFormat() {
        return this.rowFormat;
    }

    public void setRowFormat(String rowFormat) {
        this.rowFormat = rowFormat;
    }

    public String getTableRows() {
        return this.tableRows;
    }

    public void setTableRows(String tableRows) {
        this.tableRows = tableRows;
    }

    public String getAvgRowLength() {
        return this.avgRowLength;
    }

    public void setAvgRowLength(String avgRowLength) {
        this.avgRowLength = avgRowLength;
    }

    public String getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(String dataLength) {
        this.dataLength = dataLength;
    }

    public String getMaxDataLength() {
        return this.maxDataLength;
    }

    public void setMaxDataLength(String maxDataLength) {
        this.maxDataLength = maxDataLength;
    }

    public String getIndexLength() {
        return this.indexLength;
    }

    public void setIndexLength(String indexLength) {
        this.indexLength = indexLength;
    }

    public String getDataFree() {
        return this.dataFree;
    }

    public void setDataFree(String dataFree) {
        this.dataFree = dataFree;
    }

    public Long getAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(Long autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getCheckTime() {
        return this.checkTime;
    }

    public void setCheckTime(String checkTime) {
        this.checkTime = checkTime;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getCreateOptions() {
        return this.createOptions;
    }

    public void setCreateOptions(String createOptions) {
        this.createOptions = createOptions;
    }

    public String getTableCollation() {
        return this.tableCollation;
    }

    public void setTableCollation(String tableCollation) {
        this.tableCollation = tableCollation;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }

    public String getTableGroupName() {
        return this.tableGroupName;
    }

    public void setTableGroupName(String tableGroupName) {
        this.tableGroupName = tableGroupName;
    }

    public ObMySqlPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(ObMySqlPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public ObMySqlTablePartition getTablePartition() {
        return this.tablePartition;
    }

    public void setTablePartition(ObMySqlTablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }
}

