/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.oboracle;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractDatabaseLink;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.List;

public class ObOracleDatabaseLink
extends AbstractDatabaseLink {
    private static final int SHARED_FLAG = 3;
    private String owner;
    private String username;
    private String host;
    private String created;
    private String password;
    private int flag;
    private String authUsr;
    private String authPwd;
    private String passwordx;
    private String authPwdx;

    public ObOracleDatabaseLink(ObOracleSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE");
        String owner = this.getOwner();
        if (this.getFlag() == 3) {
            sb.append(" SHARED");
        }
        if ("PUBLIC".equals(owner)) {
            sb.append(" PUBLIC");
        }
        sb.append(" DATABASE LINK ").append(this.getSchemaObjectName());
        String username = this.getUsername();
        if (StringUtils.isNotBlank(username)) {
            sb.append("\nCONNECT TO ");
            if ("CURRENT_USER".equals(username)) {
                sb.append("CURRENT_USER");
            } else {
                sb.append(this.wrap(username));
                if (StringUtils.isNotBlank(this.getPasswordx())) {
                    sb.append(" IDENTIFIED BY VALUES '").append(this.getPasswordx()).append("'");
                }
            }
        }
        if (StringUtils.isNotBlank(this.getAuthUsr())) {
            sb.append("\nAUTHENTICATED BY ").append(this.wrap(this.getAuthUsr()));
            if (StringUtils.isNotBlank(this.getAuthPwdx())) {
                sb.append(" IDENTIFIED BY VALUES '").append(this.getAuthPwdx()).append("'");
            }
        }
        if (StringUtils.isNotBlank(this.getHost())) {
            sb.append("\nUSING '").append(this.getHost()).append("'");
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.DBLINK, this.getSimpleObjectName(), this.terminate(sb))});
    }

    public ObOracleDatabaseLink() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObOracleDatabaseLink)) {
            return false;
        }
        ObOracleDatabaseLink other = (ObOracleDatabaseLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getFlag() != other.getFlag()) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$authUsr = this.getAuthUsr();
        String other$authUsr = other.getAuthUsr();
        if (this$authUsr == null ? other$authUsr != null : !this$authUsr.equals(other$authUsr)) {
            return false;
        }
        String this$authPwd = this.getAuthPwd();
        String other$authPwd = other.getAuthPwd();
        if (this$authPwd == null ? other$authPwd != null : !this$authPwd.equals(other$authPwd)) {
            return false;
        }
        String this$passwordx = this.getPasswordx();
        String other$passwordx = other.getPasswordx();
        if (this$passwordx == null ? other$passwordx != null : !this$passwordx.equals(other$passwordx)) {
            return false;
        }
        String this$authPwdx = this.getAuthPwdx();
        String other$authPwdx = other.getAuthPwdx();
        return !(this$authPwdx == null ? other$authPwdx != null : !this$authPwdx.equals(other$authPwdx));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObOracleDatabaseLink;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getFlag();
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $authUsr = this.getAuthUsr();
        result = result * 59 + ($authUsr == null ? 43 : $authUsr.hashCode());
        String $authPwd = this.getAuthPwd();
        result = result * 59 + ($authPwd == null ? 43 : $authPwd.hashCode());
        String $passwordx = this.getPasswordx();
        result = result * 59 + ($passwordx == null ? 43 : $passwordx.hashCode());
        String $authPwdx = this.getAuthPwdx();
        result = result * 59 + ($authPwdx == null ? 43 : $authPwdx.hashCode());
        return result;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public String getAuthUsr() {
        return this.authUsr;
    }

    public void setAuthUsr(String authUsr) {
        this.authUsr = authUsr;
    }

    public String getAuthPwd() {
        return this.authPwd;
    }

    public void setAuthPwd(String authPwd) {
        this.authPwd = authPwd;
    }

    public String getPasswordx() {
        return this.passwordx;
    }

    public void setPasswordx(String passwordx) {
        this.passwordx = passwordx;
    }

    public String getAuthPwdx() {
        return this.authPwdx;
    }

    public void setAuthPwdx(String authPwdx) {
        this.authPwdx = authPwdx;
    }
}

