/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.tablefmt;

import com.oceanbase.tools.loaddump.tablefmt.Filler;

public class BorderStyle {
    public static final BorderStyle HORIZONTAL_ONLY = new BorderStyle("", "-", "-", "", "", "-", "-", "", "", "-", "-", "", "", "|", "", " ", " ");
    private static final String DEFAULT_TILE = "*";
    private String tLCorner;
    private String top;
    private String tCCorner;
    private String tRCorner;
    private String mLCorner;
    private String middle;
    private String mCCorner;
    private String mRCorner;
    private String bLCorner;
    private String bottom;
    private String bCCorner;
    private String bRCorner;
    private String left;
    private String center;
    private String right;
    private String upperColSpan;
    private String lowerColSpan;
    private int leftWidth;
    private int horizontalWidth;
    private int centerWidth;
    private int rightWidth;

    public BorderStyle(String tLCorner, String top, String tCCorner, String tRCorner, String mLCorner, String middle, String mCCorner, String mRCorner, String bLCorner, String bottom, String bCCorner, String bRCorner, String left, String center, String right, String upperColSpan, String lowerColSpan) {
        this.leftWidth = this.maxWidth(tLCorner, mLCorner, bLCorner, left);
        this.horizontalWidth = 1;
        this.centerWidth = this.maxWidth(tCCorner, mCCorner, bCCorner, center, upperColSpan, lowerColSpan);
        this.rightWidth = this.maxWidth(tRCorner, mRCorner, bRCorner, right);
        this.tLCorner = this.adjustString(tLCorner, this.leftWidth);
        this.top = this.adjustString(top, this.horizontalWidth);
        this.tCCorner = this.adjustString(tCCorner, this.centerWidth);
        this.tRCorner = this.adjustString(tRCorner, this.rightWidth);
        this.mLCorner = this.adjustString(mLCorner, this.leftWidth);
        this.middle = this.adjustString(middle, this.horizontalWidth);
        this.mCCorner = this.adjustString(mCCorner, this.centerWidth);
        this.mRCorner = this.adjustString(mRCorner, this.rightWidth);
        this.bLCorner = this.adjustString(bLCorner, this.leftWidth);
        this.bottom = this.adjustString(bottom, this.horizontalWidth);
        this.bCCorner = this.adjustString(bCCorner, this.centerWidth);
        this.bRCorner = this.adjustString(bRCorner, this.rightWidth);
        this.left = this.adjustString(left, this.leftWidth);
        this.center = this.adjustString(center, this.centerWidth);
        this.right = this.adjustString(right, this.rightWidth);
        this.upperColSpan = this.adjustString(upperColSpan, this.centerWidth);
        this.lowerColSpan = this.adjustString(lowerColSpan, this.centerWidth);
    }

    public BorderStyle(String customStyle) {
        this.leftWidth = 1;
        this.horizontalWidth = 1;
        this.centerWidth = 1;
        this.rightWidth = 1;
        this.tLCorner = this.get(customStyle, 0);
        this.top = this.get(customStyle, 1);
        this.tCCorner = this.get(customStyle, 2);
        this.tRCorner = this.get(customStyle, 3);
        this.mLCorner = this.get(customStyle, 4);
        this.middle = this.get(customStyle, 5);
        this.mCCorner = this.get(customStyle, 6);
        this.mRCorner = this.get(customStyle, 7);
        this.bLCorner = this.get(customStyle, 8);
        this.bottom = this.get(customStyle, 9);
        this.bCCorner = this.get(customStyle, 10);
        this.bRCorner = this.get(customStyle, 11);
        this.left = this.get(customStyle, 12);
        this.center = this.get(customStyle, 13);
        this.right = this.get(customStyle, 14);
        this.upperColSpan = this.get(customStyle, 15);
        this.lowerColSpan = this.get(customStyle, 16);
    }

    private int maxWidth(String a, String b, String c) {
        return Math.max(Math.max(this.tileWidth(a), this.tileWidth(b)), this.tileWidth(c));
    }

    private int maxWidth(String a, String b, String c, String d) {
        return Math.max(Math.max(Math.max(this.tileWidth(a), this.tileWidth(b)), this.tileWidth(c)), this.tileWidth(d));
    }

    private int maxWidth(String a, String b, String c, String d, String e, String f) {
        return Math.max(this.maxWidth(a, b, c), this.maxWidth(d, e, f));
    }

    private String adjustString(String txt, int width) {
        if (txt == null) {
            return Filler.getFiller(width);
        }
        if (txt.length() == width) {
            return txt;
        }
        if (txt.length() > width) {
            return txt.substring(0, width);
        }
        int diff = width - txt.length();
        return txt + Filler.getFiller(diff);
    }

    private int tileWidth(String tile) {
        if (tile == null) {
            return 0;
        }
        return tile.length();
    }

    private String get(String style, int index) {
        if (style == null) {
            return DEFAULT_TILE;
        }
        if (index < 0 || index >= style.length()) {
            return DEFAULT_TILE;
        }
        return style.substring(index, index + 1);
    }

    public String getBCCorner() {
        return this.bCCorner;
    }

    public String getBLCorner() {
        return this.bLCorner;
    }

    public String getBottom() {
        return this.bottom;
    }

    public String getBRCorner() {
        return this.bRCorner;
    }

    public String getCenter() {
        return this.center;
    }

    public String getLeft() {
        return this.left;
    }

    public String getMCCorner() {
        return this.mCCorner;
    }

    public String getMiddle() {
        return this.middle;
    }

    public String getMLCorner() {
        return this.mLCorner;
    }

    public String getMRCorner() {
        return this.mRCorner;
    }

    public String getRight() {
        return this.right;
    }

    public String getTop() {
        return this.top;
    }

    public String getTCCorner() {
        return this.tCCorner;
    }

    public String getTLCorner() {
        return this.tLCorner;
    }

    public String getTRCorner() {
        return this.tRCorner;
    }

    public String getUpperColSpan() {
        return this.upperColSpan;
    }

    public String getLowerColSpan() {
        return this.lowerColSpan;
    }

    public int getLeftWidth() {
        return this.leftWidth;
    }

    public int getHorizontalWidth() {
        return this.horizontalWidth;
    }

    public int getCenterWidth() {
        return this.centerWidth;
    }

    public int getRightWidth() {
        return this.rightWidth;
    }
}

