/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file;

import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractRollingFileWriter
extends AbstractFileWriter {
    private static final Logger log = LoggerFactory.getLogger(AbstractRollingFileWriter.class);
    private final int groupNo;
    private final String filePath;
    private final String fileName;
    private final String fileSuffix;
    protected String activeFile;
    protected boolean closed;
    private boolean rollable;
    private boolean retainEmptyFiles;
    private ConcurrentHashMap<String, AtomicLong> identicalNoMap;
    private final AtomicInteger sequenceNo = new AtomicInteger(0);
    private final AtomicLong fileSize = new AtomicLong(0L);

    public AbstractRollingFileWriter(int groupNo, String filePath, String fileName, String fileSuffix) {
        super(filePath, fileName, fileSuffix);
        this.groupNo = groupNo;
        this.filePath = filePath;
        this.fileName = fileName;
        this.fileSuffix = fileSuffix;
    }

    public AbstractRollingFileWriter rollover() throws Exception {
        return this.rollover(Integer.getInteger("fs.page", 0x100000));
    }

    private AbstractRollingFileWriter rollover(int bufferSize) throws Exception {
        this.attemptCloseResource();
        this.attemptRollover();
        return this.current(bufferSize);
    }

    public abstract void attemptCloseResource();

    private void attemptRollover() {
        if (!this.rollable) {
            throw new UnsupportedOperationException("Rollover not supported");
        }
        this.sequenceNo.incrementAndGet();
    }

    public abstract AbstractRollingFileWriter current() throws Exception;

    public abstract AbstractRollingFileWriter current(int var1) throws Exception;

    public String createNewFile() {
        String fileName = this.generateFileName(null);
        String activeFilePath = FileUtils.toPath(this.filePath, fileName);
        if (new File(activeFilePath).exists()) {
            String fs = this.fileSuffix;
            String[] extensions = new String[]{fs.startsWith(".") ? fs.substring(1) : fs};
            for (String existsFileName : FileUtils.listFileNames(new File(this.getFilePath()), extensions)) {
                if (existsFileName.equals(fileName) || !existsFileName.equalsIgnoreCase(fileName)) continue;
                AtomicLong identicalNo = this.identicalNoMap.computeIfAbsent(existsFileName, v -> new AtomicLong(0L));
                activeFilePath = FileUtils.toPath(this.filePath, this.generateFileName(identicalNo));
            }
        }
        try {
            FileUtils.touch((File)new File(activeFilePath));
        }
        catch (Exception e) {
            log.warn("Exec touch file: \"{}\" failed. Warn: {}", (Object)activeFilePath, (Object)ExceptionUtils.getRootCauseMessage(e));
        }
        return activeFilePath;
    }

    private String generateFileName(AtomicLong identicalNo) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.fileName);
        if (identicalNo != null) {
            sb.append("_ob_identical_").append(identicalNo.incrementAndGet());
        }
        if (Integer.MAX_VALUE != this.groupNo) {
            sb.append(".").append(this.groupNo);
            sb.append(".").append(this.sequenceNo.get());
        }
        return sb.append(this.fileSuffix).toString();
    }

    public void attemptDeleteEmptyFile() {
        File activeFile;
        String activeFilePath;
        if (!this.retainEmptyFiles && StringUtils.isNotBlank(activeFilePath = this.activeFile) && (activeFile = new File(activeFilePath)).exists() && FileUtils.getSize(activeFile) < 1L) {
            try {
                FileUtils.forceDelete((File)activeFile);
            }
            catch (IOException e) {
                log.warn("Delete empty file failed. Warn: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            }
        }
    }

    @Override
    public long write(Object line) throws Exception {
        throw new UnsupportedOperationException("implement by subclass");
    }

    public void writeLine(Object line) throws Exception {
        long size = this.write(line);
        this.fileSize.addAndGet(size);
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public String getActiveFile() {
        return this.activeFile;
    }

    public void setRollable(boolean rollable) {
        this.rollable = rollable;
    }

    public void setRetainEmptyFiles(boolean retainEmptyFiles) {
        this.retainEmptyFiles = retainEmptyFiles;
    }

    public void setIdenticalNoMap(ConcurrentHashMap<String, AtomicLong> identicalNoMap) {
        this.identicalNoMap = identicalNoMap;
    }
}

