/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file;

import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractRollingFileWriterV2
extends AbstractFileWriter {
    protected static final int NOT_ROLL_FLAG = 0;
    protected final AtomicInteger participant;
    protected String currentFilePath;
    protected int sequenceNo = 0;
    protected long blockSize;
    protected int blockRow;
    protected final Lock lock = new ReentrantLock();
    protected long currentBlockSize = 0L;
    protected long currentBlockRowCnt = 0L;

    public AbstractRollingFileWriterV2(String filePath, String fileName, String fileSuffix, long blockSize, int blockRow, int participant) {
        super(filePath, fileName, fileSuffix);
        this.blockSize = blockSize;
        this.blockRow = blockRow;
        this.participant = new AtomicInteger(participant);
        this.currentFilePath = this.assembleAbsFilePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(Object line) throws Exception {
        this.lock.lock();
        try {
            long byteSize = this.writeInternal(line);
            this.currentBlockSize += byteSize;
            ++this.currentBlockRowCnt;
            if (this.blockSize != 0L && this.currentBlockSize >= this.blockSize) {
                this.rollover();
            } else if (this.blockRow != 0 && this.currentBlockRowCnt >= (long)this.blockRow) {
                this.rollover();
            }
            long l = byteSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void createEmpty() throws IOException {
        File f = new File(this.currentFilePath);
        if (f.exists()) {
            FileUtils.forceDelete((File)f);
        }
        FileUtils.touch((File)f);
    }

    public void markDone() throws Exception {
        if (this.participant.decrementAndGet() == 0) {
            this.finishOff();
        }
    }

    protected void finishOff() throws Exception {
        this.close();
    }

    protected abstract long writeInternal(Object var1) throws Exception;

    protected void rollover() throws Exception {
        ++this.sequenceNo;
        this.currentBlockSize = 0L;
        this.currentBlockRowCnt = 0L;
        this.currentFilePath = this.assembleAbsFilePath();
    }

    protected String assembleAbsFilePath() {
        if (this.blockSize == 0L && this.blockRow == 0) {
            return FileUtils.toPath(this.filePath, this.fileName + this.fileSuffix);
        }
        return FileUtils.toPath(this.filePath, this.fileName + "." + this.sequenceNo + this.fileSuffix);
    }

    public String getCurrentFilePath() {
        return this.currentFilePath;
    }

    public static abstract class Builder {
        protected String filePath;
        protected String fileName;
        protected String fileSuffix;
        protected long blockSize;
        protected int blockRow;
        protected int participant;

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder fileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
            return this;
        }

        public Builder blockSize(long blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder blockRow(int blockRow) {
            this.blockRow = blockRow;
            return this;
        }

        public Builder participant(int participant) {
            this.participant = participant;
            return this;
        }

        public abstract AbstractRollingFileWriterV2 build();
    }
}

