/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRollingUploadWriter
extends AbstractRollingFileWriterV2 {
    private static final Logger log = LoggerFactory.getLogger(AbstractRollingUploadWriter.class);
    protected AbstractRollingFileWriterV2 localFileWriter;

    public AbstractRollingUploadWriter(AbstractRollingFileWriterV2 localFileWriter) {
        super(localFileWriter.getFilePath(), localFileWriter.getFileName(), localFileWriter.getFileSuffix(), localFileWriter.blockSize, localFileWriter.blockRow, localFileWriter.participant.get());
        Preconditions.checkState((!(localFileWriter instanceof AbstractRollingUploadWriter) ? 1 : 0) != 0, (Object)"Local file writer shouldn't be a RollingUploadWriter instance");
        this.localFileWriter = localFileWriter;
    }

    @Override
    protected long writeInternal(Object line) throws Exception {
        return this.localFileWriter.writeInternal(line);
    }

    @Override
    protected void rollover() throws Exception {
        this.localFileWriter.rollover();
        this.upload();
        super.rollover();
    }

    @Override
    protected void finishOff() throws Exception {
        this.localFileWriter.close();
        if (FileUtils.exists(this.currentFilePath)) {
            this.upload();
        }
        super.finishOff();
    }

    protected abstract void upload() throws IOException;

    @Override
    public void createEmpty() throws IOException {
        this.localFileWriter.createEmpty();
        this.upload();
    }

    public void setLocalFileWriter(AbstractRollingFileWriterV2 localFileWriter) {
        this.localFileWriter = localFileWriter;
    }
}

