/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.hdfs;

import com.oceanbase.tools.loaddump.common.model.storage.remote.hdfs.HdfsStorageConfig;
import com.oceanbase.tools.loaddump.writer.file.CsvWriter;
import com.oceanbase.tools.loaddump.writer.file.hdfs.HdfsFlatFileWriter;

public class HdfsCsvFileWriter
extends HdfsFlatFileWriter
implements CsvWriter {
    private String header;

    public HdfsCsvFileWriter(String filePath, String fileName, String fileSuffix, String fileEncoding, String header, long blockSize, int blockRow, int participant, HdfsStorageConfig conf) {
        super(filePath, fileName, fileSuffix, fileEncoding, blockSize, blockRow, participant, conf);
        this.header = header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(Object line) throws Exception {
        this.lock.lock();
        try {
            if (this.currentBlockSize == 0L) {
                this.writeInternal(this.header);
            }
            long l = super.write(line);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setCsvHeader(String header) {
        this.header = header;
    }

    public static class Builder
    extends HdfsFlatFileWriter.Builder {
        String header;

        public Builder header(String header) {
            this.header = header;
            return this;
        }

        @Override
        public HdfsCsvFileWriter build() {
            return new HdfsCsvFileWriter(this.filePath, this.fileName, this.fileSuffix, this.fileEncoding, this.header, this.blockSize, this.blockRow, this.participant, this.storageConfig);
        }
    }
}

