/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.hdfs;

import com.oceanbase.tools.loaddump.common.model.storage.remote.hdfs.HdfsStorageConfig;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import com.oceanbase.tools.loaddump.writer.file.local.FlatFileWriterV2;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsFlatFileWriter
extends FlatFileWriterV2 {
    protected FileSystem fs;
    protected HdfsStorageConfig storageConfig;

    public HdfsFlatFileWriter(String filePath, String fileName, String fileSuffix, String fileEncoding, long blockSize, int blockRow, int participant, HdfsStorageConfig conf) {
        super(filePath, fileName, fileSuffix, fileEncoding, blockSize, blockRow, participant);
        this.storageConfig = conf;
        this.fs = conf.createHdfsSystem();
    }

    @Override
    public void createEmpty() throws IOException {
        Path hPath = new Path(this.storageConfig.assembleDestPath(new File(this.currentFilePath)));
        if (this.fs.exists(hPath)) {
            this.fs.delete(hPath, false);
        }
        this.fs.create(hPath).close();
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.bw != null) {
            this.bw.close();
            this.bw = null;
        }
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        this.closed = true;
    }

    @Override
    protected BufferedWriter createBufferWriter() throws IOException {
        Path hPath = new Path(this.storageConfig.assembleDestPath(new File(this.currentFilePath)));
        FSDataOutputStream os = this.fs.create(hPath, true);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)os, this.fileEncoding), 0x100000);
    }

    public static class Builder
    extends FlatFileWriterV2.Builder {
        HdfsStorageConfig storageConfig;

        public Builder storageConfig(HdfsStorageConfig hadoopConfig) {
            this.storageConfig = hadoopConfig;
            return this;
        }

        @Override
        public AbstractRollingFileWriterV2 build() {
            return new HdfsFlatFileWriter(this.filePath, this.fileName, this.fileSuffix, this.fileEncoding, this.blockSize, this.blockRow, this.participant, this.storageConfig);
        }
    }
}

