/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.UploadFileRequest;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.factory.ObjectStorageClientFactory;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingUploadWriter;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssRollingUploadWriter
extends AbstractRollingUploadWriter {
    private static final Logger log = LoggerFactory.getLogger(OssRollingUploadWriter.class);
    private final OssStorageConfig storageConfig;
    private OSS client;

    public OssRollingUploadWriter(AbstractRollingFileWriterV2 localFileWriter, OssStorageConfig storageConfig) {
        super(localFileWriter);
        this.storageConfig = storageConfig;
        this.client = ObjectStorageClientFactory.createOssClient(storageConfig);
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.localFileWriter != null) {
            this.localFileWriter.close();
            this.localFileWriter = null;
        }
        this.client.shutdown();
        this.client = null;
        this.closed = true;
    }

    @Override
    protected void upload() throws IOException {
        File uploadFile = new File(this.currentFilePath);
        String objectKey = this.storageConfig.assembleDestPath(uploadFile);
        UploadFileRequest uploadFileRequest = new UploadFileRequest(this.storageConfig.getBucket(), objectKey);
        uploadFileRequest.setUploadFile(this.currentFilePath);
        uploadFileRequest.setPartSize(0x100000L);
        log.info("Uploading \"{}\" ...", (Object)this.currentFilePath);
        try {
            this.client.uploadFile(uploadFileRequest);
            try {
                FileUtils.forceDelete((File)uploadFile);
            }
            catch (IOException e) {
                log.warn("Failed to delete local file \"{}\". Reason: {}", (Object)this.currentFilePath, (Object)e);
            }
        }
        catch (Throwable e) {
            log.error("Upload \"{}\" failed, local file will not be deleted. Error: {}", (Object)this.currentFilePath, (Object)e);
            throw new IOException(e);
        }
    }
}

