/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.Manifest;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.loader.record.RecordFileLoader;
import com.oceanbase.tools.loaddump.loader.schema.SchemaFileLoader;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.logging.log4j.ThreadContext;

public class LoadClient
implements Closeable {
    protected State state;
    protected final LoadParameter parameter;
    protected boolean closed;
    protected ConnectionKey connectionKey;

    protected LoadClient(LoadParameter parameter) {
        this.parameter = parameter;
    }

    private void rectifyFilePath() {
        Path p = new Path(this.parameter.getFilePath());
        FileSystem fs = this.parameter.getStorageConfig().getFileSystem();
        try {
            Preconditions.checkArgument((boolean)fs.exists(p), (String)"Resource path %s is not exist", (Object)p);
            FileStatus status = fs.getFileStatus(p);
            if (status.isDirectory()) {
                this.parameter.setFilePath(p.toString());
            } else {
                this.parameter.setInputFile(status);
                this.parameter.setFilePath(p.getParent().toString());
                this.parameter.getWhiteListMap().put(ObjectType.FILE, Sets.newHashSet((Object[])new String[]{p.getName()}));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("File system operation error. Reason: " + e.getMessage());
        }
        Set<String> tableSet = this.parameter.getWhiteListMap().get((Object)ObjectType.TABLE);
        Preconditions.checkArgument((this.parameter.getDataFormat() == DataFormat.MIX || this.parameter.getInputFile() == null || tableSet == null || tableSet.size() == 1 ? 1 : 0) != 0, (Object)"One table can only correspond to one data file");
    }

    public TaskContext loadSchema() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"Not initialized");
        Preconditions.checkArgument((this.parameter.isIncludeDdl() || DataFormat.MIX == this.parameter.getDataFormat() ? 1 : 0) != 0, (String)"Option %s is missing", (Object)DataFormat.appendSchemaOption());
        return new SchemaFileLoader(this.parameter).prepare().loadSchemaAsync();
    }

    public TaskContext loadRecord() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"Not initialized");
        DataFormat dataFormat = this.parameter.getDataFormat();
        Preconditions.checkArgument((dataFormat != null && dataFormat != DataFormat.DDL && dataFormat != DataFormat.MIX ? 1 : 0) != 0, (String)"Option %s is missing", (Object)DataFormat.appendRecordOption());
        ConnectionKey connectionKey = this.parameter.getConnectionKey();
        AdvancedOption advancedOption = new AdvancedOption(this.parameter, connectionKey.getServerMode());
        Database database = connectionKey.getMetadataProvider().queryDatabase(connectionKey, advancedOption);
        this.parameter.setDatabase(database);
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(database.getTableInfoMap()), (String)"The base tables (non temporary) are not found in the schema: %s. Please check the --table option!", (Object)database.getSchemaName());
        return new RecordFileLoader(this.parameter).prepare().loadRecordAsync();
    }

    @Override
    public void close() {
        FileSystem fs;
        if (this.closed) {
            return;
        }
        if (this.connectionKey != null) {
            this.connectionKey.getSessionManager().destroy();
        }
        if ((fs = this.parameter.getStorageConfig().getFileSystem()) != null) {
            try {
                fs.close();
            }
            catch (IOException e) {
                LogUtils.warn("Release file system resources failed. Reason: {}", e.getMessage());
            }
        }
        this.closed = true;
    }

    public static class Builder {
        private final LoadParameter parameter;

        public Builder(LoadParameter parameter) {
            this.parameter = parameter;
        }

        public LoadClient build() throws Exception {
            Set<String> excludeDataTypes;
            Set<String> excludeColumnName;
            LoadClient target = new LoadClient(this.parameter);
            target.rectifyFilePath();
            LogUtils.info("Log files will be written to {}", this.parameter.getLogsPath());
            System.setProperty("logging.path", this.parameter.getLogsPath());
            System.setProperty("logging.level", "INFO");
            ThreadContext.put((String)"task.workspace", (String)this.parameter.getLogsPath());
            ConnectionKey connectionKey = this.parameter.buildConnectionKey();
            ServerMode serverMode = connectionKey.getServerMode();
            Database database = new Database(this.parameter.getDatabaseName());
            database.setServerMode(serverMode);
            database.setSubsequentV4(serverMode.isSubsequent("4.0.0.0"));
            this.parameter.setDatabase(database);
            Set tableSet = this.parameter.getWhiteListMap().getOrDefault((Object)ObjectType.TABLE, new HashSet());
            if (this.parameter.getDataFormat() != DataFormat.MIX && StringUtils.isNotBlank(this.parameter.getCtlPath())) {
                ControlManager cm = ControlManager.parse(new File(this.parameter.getCtlPath()), this.parameter.getDatabaseName(), tableSet, serverMode);
                this.parameter.setControlManager(cm);
                if (MapUtils.isEmpty(this.parameter.getColumnNameMapping())) {
                    this.parameter.getColumnNameMapping().putAll(cm.getColumnNameMapping());
                }
            }
            if (!serverMode.isPrevious("3.2.4.0")) {
                int openCursors = connectionKey.getMetadataProvider().queryOpenCursors();
                Preconditions.checkArgument((openCursors > this.parameter.getThreads() ? 1 : 0) != 0, (String)"The system config `open_cursors` value(%s) may be not enough. Please set system parameter `open_cursors` to 1000 or larger manually.", (int)openCursors);
            }
            if (serverMode.isPrevious("4.2.0.0")) {
                Preconditions.checkState((!this.parameter.isDirectMode() ? 1 : 0) != 0, (Object)"The direct load feature is only supported by OceanBase 4.2.0 and later.");
            }
            if (this.parameter.isEnableHiddenPk()) {
                Preconditions.checkState((boolean)serverMode.isPreviousV4(), (Object)"Option --enable-hidden-pk is unsupported for OceanBase v4.0+.");
                if (serverMode.isMysqlMode() && !connectionKey.getUsername().equals("__oceanbase_inner_drc_user")) {
                    throw new IllegalArgumentException("The user with option --enable-hidden-pk must be \"__oceanbase_inner_drc_user\"");
                }
                if (serverMode.isOracleMode() && !connectionKey.getUsername().equals("__OCEANBASE_INNER_DRC_USER")) {
                    throw new IllegalArgumentException("The user with option --enable-hidden-pk must be \"__OCEANBASE_INNER_DRC_USER\"");
                }
            }
            Manifest manifest = new Manifest(this.parameter);
            if (this.parameter.getDataFormat() == DataFormat.CSV && !this.parameter.isExternal() && FileUtils.exists(manifest.toPathCompat())) {
                try {
                    manifest = (Manifest)SerializeUtils.deserializeObjectByKryo(manifest.toPathCompat());
                    LogUtils.info("Manifest has been saved to \"{}\"", manifest.toPath());
                    manifest.replaceTo(this.parameter);
                }
                catch (Exception e) {
                    LogUtils.info("Deserialization of \".MANIFEST.bin\" failed. It may affect the the parser's functionality, if so, you may add valid csv format options that correspond to the data file.\n-\tNote: \".MANIFEST.bin\" is a binary file that specifies the current CSV format, in most cases, it's not necessary and okay to be ignored. It will be deprecated soon.");
                }
            }
            this.parameter.getWhiteListMap().forEach((k, v) -> {
                Set newV = (Set)DBUtils.toCaseInsensitiveCollections(serverMode, v, HashSet::new);
                this.parameter.getWhiteListMap().put((ObjectType)((Object)k), newV);
            });
            this.parameter.getBlackListMap().forEach((k, v) -> {
                Set newV = (Set)DBUtils.toCaseInsensitiveCollections(serverMode, v, HashSet::new);
                this.parameter.getBlackListMap().put((ObjectType)((Object)k), newV);
            });
            LinkedHashSet<String> includeColumnNames = this.parameter.getIncludeColumnNames();
            if (!includeColumnNames.isEmpty()) {
                Collection<String> newV = DBUtils.toCaseInsensitiveCollections(serverMode, includeColumnNames, LinkedHashSet::new);
                includeColumnNames.clear();
                includeColumnNames.addAll(newV);
            }
            if (!(excludeColumnName = this.parameter.getExcludeColumnNames()).isEmpty()) {
                Collection<String> newV = DBUtils.toCaseInsensitiveCollections(serverMode, excludeColumnName, HashSet::new);
                excludeColumnName.clear();
                excludeColumnName.addAll(newV);
            }
            if (!(excludeDataTypes = this.parameter.getExcludeDataTypes()).isEmpty()) {
                Set newV = excludeDataTypes.stream().map(t -> t.toLowerCase(Locale.getDefault())).collect(Collectors.toSet());
                excludeDataTypes.clear();
                excludeDataTypes.addAll(newV);
            }
            target.state = State.INITIAL;
            return target;
        }
    }
}

