/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.cmd;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.client.DumpClient;
import com.oceanbase.tools.loaddump.client.SelectIntoOutfileClient;
import com.oceanbase.tools.loaddump.cmd.AbstractCommandParser;
import com.oceanbase.tools.loaddump.cmd.Common;
import com.oceanbase.tools.loaddump.cmd.CustomHelpSectionRenderer;
import com.oceanbase.tools.loaddump.cmd.ObjectTypes;
import com.oceanbase.tools.loaddump.cmd.VersionProvider;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.exception.NoTaskGeneratedException;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.vmoption.JavaOpts;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="obdumper", subcommands={CommandLine.HelpCommand.class}, resourceBundle="com.oceanbase.loaddump.bundle.cli", versionProvider=VersionProvider.class, sortOptions=false, header={"@|green    ____                                  ____                       |@", "@|green   / __ \\  _____  ___   ____ _   ____    / __ )  ____ _   _____  ___ |@", "@|green  / / / / / ___/ / _ \\ / __ `/  / __ \\  / __  | / __ `/  / ___/ / _ \\|@", "@|green / /_/ / / /__  /  __// /_/ /  / / / / / /_/ / / /_/ /  (__  ) /  __/|@", "@|green \\____/  \\___/  \\___/ \\__,_/  /_/ /_/ /_____/  \\__,_/  /____/  \\___/ |@", "@|green                                                                     |@"}, footer={"%nExamples:", "@|italic \te.g: ./obdumper -h 192.168.0.0 -P 2883 -u xxx -t tenantA -c ClusterA -p xxx --sys-password xxxx -D USERA --ddl --all -f /Users/admin/DUMP-1/%n |@", "@|italic \te.g: ./obdumper -h 192.168.0.0 -P 2883 -u xxx -t tenantA -c ClusterA -p xxx --sys-password xxxx -D USERA --csv --all -f /Users/admin/DUMP-1/%n |@"})
public class Obdumper
extends AbstractCommandParser
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Obdumper.class);
    @CommandLine.Option(names={"--where"}, description={"Interpret to dump data by where condition"})
    private String where;
    @CommandLine.Option(names={"--snapshot"}, description={"Interpret to dump the snapshot data"})
    private boolean snapshot;
    @Deprecated
    @CommandLine.Option(names={"--weak-read"}, description={"Interpret to dump from follower server"})
    private boolean weakRead;
    @CommandLine.Option(names={"--distinct"}, description={"Interpret to dump the distinct data"})
    private boolean distinct;
    @CommandLine.Option(names={"--page-size"}, description={"Interpret the page size for per query"})
    private int pageSize = 1000000;
    @CommandLine.Option(names={"--commit-size"}, description={"Interpret the commit size for dumper"})
    private int commitSize = 2000;
    @CommandLine.Option(names={"--partition"}, split=",", paramLabel="partition", description={"Interpret to dump data from the partition"})
    private List<String> partitions;
    @CommandLine.Option(names={"--query-sql"}, description={"Interpret to dump data by the custom query sql"})
    private String querySql;
    @Deprecated
    @CommandLine.Option(names={"--file-name"}, description={"Interpret to merge data files into a large file"})
    private String fileName;
    @CommandLine.Option(names={"--no-nested-dir"}, description={"Export files without complex directory hierarchy, placing all exported files directly in the user-specified directory."})
    private boolean noNestedDir;
    @CommandLine.Option(names={"--date-value-format"}, description={"Interpret to dump date type record(oboracle) by specified date format"})
    private String dateValueFormat;
    @CommandLine.Option(names={"--datetime-value-format"}, description={"Interpret to dump datetime type record by specified datetime format"})
    private String datetimeValueFormat;
    @CommandLine.Option(names={"--timestamp-value-format"}, description={"Interpret to dump timestamp type record by specified timestamp format"})
    private String timestampValueFormat;
    @CommandLine.Option(names={"--timestamp-tz-value-format"}, description={"Interpret to dump timestamp type record by specified timestamp with time zone format"})
    private String timestampTzValueFormat;
    @CommandLine.Option(names={"--timestamp-ltz-value-format"}, description={"Interpret to dump timestamp type record by specified timestamp with local time zone format"})
    private String timestampLtzValueFormat;
    @CommandLine.Option(names={"--time-value-format"}, description={"Interpret to dump time type record by specified time format"})
    private String timeValueFormat;
    @CommandLine.Option(names={"--drop-object"}, description={"Interpret to prepend drop statement"})
    private boolean dropObject;
    @CommandLine.Option(names={"--skip-check-dir"}, description={"Interpret to check the target dir"})
    private boolean skipCheckDir;
    @CommandLine.Option(names={"--add-extra-message"}, description={"Interpret to dump with extra message"})
    private boolean addExtraMessage;
    @CommandLine.Option(names={"--remove-newline"}, description={"Interpret to remove line break"})
    private boolean removeNewLine;
    @CommandLine.Option(names={"--retain-empty-files"}, description={"Interpret to retain empty files"})
    private boolean retainEmptyFiles;
    @CommandLine.Option(names={"--exclude-virtual-columns"}, description={"Interpret to exclude virtual columns"})
    private boolean excludeVirtualColumns;
    @Deprecated
    @CommandLine.Option(names={"--max-file-size"}, description={"Interpret the max size of output file"})
    private long maxFileSize = -1048576L;
    @CommandLine.Option(names={"--parallel-macro"}, description={"Interpret the parallism of macro list"})
    private int parallelMacro = 8;
    @CommandLine.Option(names={"--flashback-scn"}, description={"Interpret to dump data by flashback scn"})
    private String flashbackScn;
    @CommandLine.Option(names={"--flashback-timestamp"}, description={"Interpret to dump data by flashback timestamp"})
    private String flashbackTimestamp;
    @CommandLine.Option(names={"--block-size"}, description={"Interpret the block size in MB or in record rows for large file"})
    private String blockSize;
    @CommandLine.Option(names={"--upload-behavior"}, description={"Interpret the upload behavior. e.g. FAST, COMPLETE"})
    @Deprecated
    private String uploadBehavior;
    @CommandLine.Option(names={"--fetch-size"}, description={"Interpret the JDBC variable 'fetchSize' used for performance tuning. Default: 1000"})
    private int fetchSize = 1000;
    @CommandLine.Option(names={"--preserve-zero-datetime"}, description={"Interpret whether to preserve the original form of zero datetime values, which will be converted to null by default."})
    private boolean preserveZeroDatetime = false;
    @CommandLine.Option(names={"--compact-schema"}, description={"Export the schema text which are retrieved by executing `show create table`."})
    private boolean compactSchema = true;
    @CommandLine.Option(names={"--schemaless"}, description={"Export ddl without schema name prefix."})
    private boolean schemaless = true;

    public static void main(String[] args) {
        Obdumper dumper = new Obdumper();
        CommandLine cmd = new CommandLine((Object)dumper);
        cmd.parseArgs(args);
        boolean isSubHelp = false;
        CustomHelpSectionRenderer custom = new CustomHelpSectionRenderer(TaskType.DUMP);
        if (args.length == 1) {
            for (String key : CustomHelpSectionRenderer.DUMPER_OPTION_MAPPING.keySet()) {
                if (!key.equals(args[0].trim())) continue;
                custom.setDependent(key);
                isSubHelp = true;
                break;
            }
        }
        cmd.getHelpSectionMap().put("optionList", custom);
        cmd.setUsageHelpAutoWidth(true);
        cmd.setUsageHelpLongOptionsMaxWidth(60);
        cmd.setUsageHelpWidth(150);
        if (cmd.isUsageHelpRequested() || args.length == 0 || isSubHelp) {
            cmd.usage(cmd.getOut());
        } else if (cmd.isVersionHelpRequested()) {
            cmd.printVersionHelp(cmd.getOut());
        } else {
            dumper.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.printParseArgs();
        Obdumper.checkJavaVersion();
        int status = 0;
        RuntimeMetrics metrics = new RuntimeMetrics();
        try {
            DumpParameter parameter = this.parseCommandArgs();
            if (parameter.isUseServer()) {
                Stopwatch stopwatch;
                try (SelectIntoOutfileClient selectIntoOutfileClient = new SelectIntoOutfileClient.Builder(parameter).build();){
                    stopwatch = Stopwatch.createStarted();
                    status = selectIntoOutfileClient.dumpRecords();
                }
                log.info("Remote dump record finished. Total Elapsed: {}", (Object)stopwatch.stop());
                return;
            }
            try (DumpClient client = new DumpClient.Builder(parameter).build();){
                DataFormat dataFormat;
                if (parameter.isIncludeDdl()) {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    status = (int)((long)status + super.waitUntilDone(client.dumpSchema()));
                    log.info("Dump schema finished. Total Elapsed: {}", (Object)stopwatch.stop());
                }
                if ((dataFormat = parameter.getDataFormat()) != null && dataFormat != DataFormat.MIX && dataFormat != DataFormat.DDL) {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    TaskContext context = client.dumpRecord();
                    status = (int)((long)status + super.waitUntilDone(context));
                    metrics = context.getRuntimeMetrics();
                    log.info("Dump record finished. Total Elapsed: {}", (Object)stopwatch.stop());
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof NoTaskGeneratedException && this.common.getObjectTypes() != null && this.common.getObjectTypes().isAll()) {
                log.warn(e.getMessage());
            } else {
                status = 1;
                if (JavaOpts.isMultiTask()) {
                    if (JavaOpts.isDebugable) {
                        log.error("Dump failed!", e);
                    } else {
                        log.error("Dump failed! Error: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
                    }
                } else {
                    if (JavaOpts.isDebugable) {
                        e.printStackTrace();
                    }
                    LogUtils.error("Dump failed! Error: {}", ExceptionUtils.getRootCauseMessage(e));
                }
            }
        }
        finally {
            this.doFinally(metrics, status);
        }
    }

    @Override
    protected DumpParameter parseCommandArgs() throws Exception {
        int pageSize;
        DumpParameter parameter = new DumpParameter();
        super.parseCommonArgs(parameter);
        if (parameter.isIncludeDdl() && parameter.getDataFormat() == null) {
            parameter.setDataFormat(DataFormat.DDL);
        }
        Common.Base base = this.common.getBase();
        this.parseQuerySql(parameter, base);
        ObjectTypes objects = this.common.getObjectTypes();
        if (StringUtils.isNotBlank(this.querySql)) {
            ArrayList tableNames = objects == null ? Lists.newArrayList((Object[])new String[]{"CUSTOM_SQL"}) : objects.getTables();
            Preconditions.checkArgument((tableNames.size() < 2 ? 1 : 0) != 0, (Object)"Option --table should contain 1 table name for --query-sql at most");
            String tableName = StringUtils.isBlank((CharSequence)tableNames.get(0)) || "*".equals(tableNames.get(0)) ? "CUSTOM_SQL" : (String)tableNames.get(0);
            parameter.getWhiteListMap().put(ObjectType.TABLE, Sets.newHashSet((Object[])new String[]{tableName}));
        } else {
            Preconditions.checkArgument((objects != null ? 1 : 0) != 0, (Object)"Option --all, --table or other object options are missing");
            parameter.setFailOnNoTaskToProceed(!objects.isAll());
            parameter.getWhiteListMap().putAll(this.parseAllowedObjects(objects));
            parameter.getBlackListMap().putAll(this.parseDisallowedObjects(objects));
        }
        if (!base.isUseServer()) {
            this.parseOutputPath(base, parameter);
        } else {
            parameter.setFilePath(base.getFilePath());
            if (parameter.getColumnDelimiter().charValue() == '\'') {
                parameter.setColumnDelimiter(Character.valueOf('\"'));
            }
        }
        boolean useFlashback = StringUtils.isNotEmpty(this.getFlashbackScn()) || StringUtils.isNotEmpty(this.getFlashbackTimestamp());
        Preconditions.checkArgument((!this.isSnapshot() || !useFlashback ? 1 : 0) != 0, (Object)"Option --snapshot can not be used with --flashback-scn or --flashback-timestamp");
        parameter.setDistinct(this.isDistinct());
        parameter.setSnapshot(this.isSnapshot());
        parameter.setDroppable(this.isDropObject());
        if (this.isWeakRead()) {
            parameter.getSessionConfig().addInitSql4Both("SET ob_read_consistency = WEAK;");
        }
        if ((pageSize = this.getPageSize()) != 1000000) {
            if (pageSize < 300000) {
                LogUtils.warn("Page size too small, reset --page-size to '300000'");
            }
            pageSize = Math.max(pageSize, 300000);
        }
        parameter.setPageSize(pageSize);
        if (StringUtils.isNotEmpty(this.uploadBehavior)) {
            throw new UnsupportedOperationException("Option --upload-behavior is deprecated, please remove it and try again.");
        }
        parameter.setMaxFileSize(this.maxFileSize);
        parameter.setSkipCheckDir(this.skipCheckDir);
        parameter.setWithExtra(this.addExtraMessage);
        parameter.setFlashbackScn(this.flashbackScn);
        parameter.setRemoveNewline(this.removeNewLine);
        parameter.setParallelMacros(this.parallelMacro);
        parameter.setRetainEmptyFiles(this.retainEmptyFiles);
        parameter.setFlashbackTimestamp(this.flashbackTimestamp);
        parameter.setWhereClause(DBUtils.wrapWhereClause(this.where));
        parameter.setExcludeVirtualColumns(this.excludeVirtualColumns);
        parameter.setFetchSize(this.fetchSize);
        parameter.setPreserveZeroDatetime(this.preserveZeroDatetime);
        parameter.setCompactSchema(this.compactSchema);
        parameter.setSchemaless(this.schemaless);
        if (StringUtils.isNotBlank(this.getTimeValueFormat())) {
            parameter.setTimeValuePattern(this.getTimeValueFormat());
        }
        if (StringUtils.isNotBlank(this.getDatetimeValueFormat())) {
            parameter.setDatetimeValuePattern(this.getDatetimeValueFormat());
        }
        if (StringUtils.isNotBlank(this.getTimestampTzValueFormat())) {
            parameter.setTimestampTzValuePattern(this.getTimestampTzValueFormat());
        }
        if (StringUtils.isNotBlank(this.getTimestampLtzValueFormat())) {
            parameter.setTimestampLtzValuePattern(this.getTimestampLtzValueFormat());
        }
        if (!base.isSql() && StringUtils.isNotBlank(this.getDateValueFormat())) {
            parameter.setDateValuePattern(this.getDateValueFormat());
        }
        if (!base.isSql() && StringUtils.isNotBlank(this.getTimestampValueFormat())) {
            parameter.setTimestampValuePattern(this.getTimestampValueFormat());
        }
        if (this.getPartitions() != null) {
            Set<String> partitions = this.getPartitions().stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(partitions), (Object)"Cli args of --partition is required");
            parameter.setPartitions(partitions);
        }
        DataFormat dataFormat = parameter.getDataFormat();
        Set<String> tableSet = parameter.getWhiteListMap().get((Object)ObjectType.TABLE);
        if (parameter.isIncludeDdl() && dataFormat == null) {
            dataFormat = DataFormat.DDL;
            parameter.setDataFormat(dataFormat);
        }
        Preconditions.checkArgument((dataFormat != null ? 1 : 0) != 0, (String)"Option %s is missing", (Object)DataFormat.appendRecordOption());
        if (!parameter.isIncludeDdl()) {
            parameter.getWhiteListMap().clear();
            parameter.getWhiteListMap().put(ObjectType.TABLE, tableSet);
        }
        if (StringUtils.isNotEmpty(this.fileName)) {
            throw new UnsupportedOperationException("Option --file-name is deprecated, you can use option --no-nested-dir instead");
        }
        this.parseBlockSize(parameter, this.blockSize);
        Preconditions.checkArgument((this.getCommitSize() > 0 ? 1 : 0) != 0, (Object)"Option --commit-size should be a positive integer.");
        parameter.setCommitSize(this.getCommitSize());
        parameter.setSkipHeader(base.isSkipHeader());
        return parameter;
    }

    public void parseBlockSize(DumpParameter param, String blockSizeRaw) throws IllegalArgumentException {
        int cutIdx;
        if (StringUtils.isEmpty(blockSizeRaw)) {
            param.setBlockSize(0x40000000L);
            param.setBlockSizeUnit("MB");
            return;
        }
        for (cutIdx = 0; cutIdx < blockSizeRaw.length() && Character.isDigit(blockSizeRaw.charAt(cutIdx)); ++cutIdx) {
        }
        long blockSize = Long.parseLong(blockSizeRaw.substring(0, cutIdx));
        Preconditions.checkArgument((blockSize >= 0L ? 1 : 0) != 0, (Object)"Option --block-size mustn't be negative.");
        String blockSizeUnit = blockSizeRaw.substring(cutIdx);
        if ("".equals(blockSizeUnit) || "MB".equalsIgnoreCase(blockSizeUnit)) {
            param.setBlockSize(blockSize * 0x100000L);
            param.setBlockSizeUnit("MB");
        } else if ("ROW".equalsIgnoreCase(blockSizeUnit)) {
            param.setBlockSize(blockSize);
            param.setBlockSizeUnit("ROW");
        } else {
            throw new IllegalArgumentException("The unit of --block-size: \"" + blockSizeUnit + "\" is unsupported. Expected: ROW or MB, default MB.");
        }
    }

    private void parseOutputPath(Common.Base base, DumpParameter parameter) {
        String fileSuffix = base.getFileSuffix();
        Preconditions.checkArgument((StringUtils.isBlank(fileSuffix) || fileSuffix.startsWith(".") ? 1 : 0) != 0, (Object)"Option --file-suffix should start with dot('.'), e.g: '.csv'");
        parameter.setFileSuffix(StringUtils.isNotBlank(fileSuffix) ? fileSuffix : parameter.getDataFormat().getDefaultFileSuffix());
        parameter.setNoNestedDir(this.noNestedDir);
        StorageConfig storageConfig = parameter.getStorageConfig();
        Path p = new Path(storageConfig.getPath());
        FileSystem fs = storageConfig.getFileSystem();
        try {
            if (fs.exists(p)) {
                boolean ignoreOverwriteCheck;
                FileStatus status = fs.getFileStatus(p);
                boolean bl = ignoreOverwriteCheck = this.skipCheckDir || base.isRetry();
                if (status.isDirectory()) {
                    Preconditions.checkArgument((ignoreOverwriteCheck || FileUtils.isDirEmpty(fs, status) ? 1 : 0) != 0, (Object)"The output directory is not empty. Consider add cli option `--skip-check-dir` to overwrite.");
                } else {
                    Preconditions.checkArgument((boolean)ignoreOverwriteCheck, (Object)"The output file already exists. Consider add cli option `--skip-check-dir` to overwrite.");
                    this.resetPathToFile(parameter, p);
                }
            } else {
                boolean likeADir = FileUtils.isLikelyDirectory(p.toString());
                if (storageConfig.getStorageType() == StorageType.LOCAL_DISK) {
                    Preconditions.checkArgument((!likeADir ? 1 : 0) != 0, (Object)"The specified output dir doesn't exist, you may create it and try again.\n-\tNote: If you intend to dump to a file instead of a dir, ensure the file name includes an extension (e.g., 'output' should be 'output.csv') so that obdumper can recognize it as a file path.");
                    this.resetPathToFile(parameter, p);
                } else if (!likeADir) {
                    this.resetPathToFile(parameter, p);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("File system operation error.", e);
        }
    }

    private void resetPathToFile(DumpParameter parameter, Path p) {
        boolean isSingleObject = StringUtils.isNotEmpty(this.querySql) || parameter.getWhiteListMap().values().stream().mapToLong(Collection::size).sum() == 1L;
        Preconditions.checkArgument((boolean)isSingleObject, (Object)"The output path is a file path but multiple database objects have been specified.\n-\tNote: Ensure the specified path with the '-f' flag is an existing directory if you intend to export multiple objects. \n-\tOtherwise, to export a single object, avoid using wildcards(*) or '--all' alongside '-f'.");
        this.blockSize = String.valueOf(0);
        parameter.setOutputFile(p.getName());
        parameter.setFilePath(p.getParent().toString());
        parameter.setNoNestedDir(true);
    }

    private void parseQuerySql(DumpParameter parameter, Common.Base base) {
        String querySql = StringUtils.trim((String)this.getQuerySql());
        boolean useCustomSql = StringUtils.isNotBlank(querySql);
        Preconditions.checkArgument((!useCustomSql || !parameter.isIncludeDdl() ? 1 : 0) != 0, (Object)"Option --ddl and --query-sql can not be both specified.");
        Preconditions.checkArgument((!base.isEnableHiddenPk() || !useCustomSql ? 1 : 0) != 0, (Object)"Option --enable-hidden-pk and --query-sql can not be both specified.");
        if (useCustomSql) {
            if (querySql.startsWith("file://")) {
                Preconditions.checkArgument((boolean)FileUtils.exists(querySql), (Object)"Option --query-sql is specified as a non-exist file");
                try {
                    querySql = FileUtils.readFileToString((File)new File(StringUtils.substringAfter((String)querySql, (String)"file://")), (String)base.getFileEncoding());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (querySql.endsWith(";")) {
                querySql = querySql.substring(0, querySql.length() - 1);
            }
        }
        parameter.setQuerySql(querySql);
    }

    public String getWhere() {
        return this.where;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Deprecated
    public boolean isWeakRead() {
        return this.weakRead;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public List<String> getPartitions() {
        return this.partitions;
    }

    public String getQuerySql() {
        return this.querySql;
    }

    @Deprecated
    public String getFileName() {
        return this.fileName;
    }

    public boolean isNoNestedDir() {
        return this.noNestedDir;
    }

    public String getDateValueFormat() {
        return this.dateValueFormat;
    }

    public String getDatetimeValueFormat() {
        return this.datetimeValueFormat;
    }

    public String getTimestampValueFormat() {
        return this.timestampValueFormat;
    }

    public String getTimestampTzValueFormat() {
        return this.timestampTzValueFormat;
    }

    public String getTimestampLtzValueFormat() {
        return this.timestampLtzValueFormat;
    }

    public String getTimeValueFormat() {
        return this.timeValueFormat;
    }

    public boolean isDropObject() {
        return this.dropObject;
    }

    public boolean isSkipCheckDir() {
        return this.skipCheckDir;
    }

    public boolean isAddExtraMessage() {
        return this.addExtraMessage;
    }

    public boolean isRemoveNewLine() {
        return this.removeNewLine;
    }

    public boolean isRetainEmptyFiles() {
        return this.retainEmptyFiles;
    }

    public boolean isExcludeVirtualColumns() {
        return this.excludeVirtualColumns;
    }

    @Deprecated
    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public int getParallelMacro() {
        return this.parallelMacro;
    }

    public String getFlashbackScn() {
        return this.flashbackScn;
    }

    public String getFlashbackTimestamp() {
        return this.flashbackTimestamp;
    }

    public String getBlockSize() {
        return this.blockSize;
    }

    @Deprecated
    public String getUploadBehavior() {
        return this.uploadBehavior;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean isPreserveZeroDatetime() {
        return this.preserveZeroDatetime;
    }

    public boolean isCompactSchema() {
        return this.compactSchema;
    }

    public boolean isSchemaless() {
        return this.schemaless;
    }
}

