/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.cmd;

import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Objects;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import picocli.CommandLine;

public class VersionProvider
implements CommandLine.IVersionProvider {
    private static final String CLI_CONFIG_PATH = "com/oceanbase/loaddump/bundle/cli.properties";
    private static final String OS_NAME = System.getProperty("os.name");

    public String[] getVersion() throws Exception {
        try {
            return new String[]{"Version: " + this.readRuntimeVersion()};
        }
        catch (Throwable t) {
            try {
                return new String[]{"Version: " + this.readCompiledVersion()};
            }
            catch (Throwable t2) {
                Properties props = new Properties();
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(CLI_CONFIG_PATH);){
                    props.load(is);
                }
                return new String[]{"Version: " + props.getProperty("application.version", "unknown")};
            }
        }
    }

    private String readCompiledVersion() throws Exception {
        int index;
        String basePath = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("")).getPath();
        if (OS_NAME.contains("windows") && basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((index = basePath.indexOf("/target/")) != -1) {
            basePath = basePath.substring(0, index);
        }
        VersionParserHandler handler = new VersionParserHandler();
        SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
        sp.parse(new File(FileUtils.toPath(basePath, "pom.xml")), (DefaultHandler)handler);
        return handler.getVersion();
    }

    private String readRuntimeVersion() throws Exception {
        String jarPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
        jarPath = URLDecoder.decode(jarPath, "UTF-8");
        URL url = new URL("jar:file:" + jarPath + "!/META-INF/maven/com.oceanbase/ob-loader-dumper/pom.properties");
        try (InputStream is = url.openStream();){
            Properties properties = new Properties();
            properties.load(is);
            String string = properties.getProperty("version");
            return string;
        }
    }

    static class VersionParserHandler
    extends DefaultHandler {
        private boolean versionNode;
        private String version;

        VersionParserHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            this.versionNode = "version".equals(qName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            this.versionNode = false;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            if (this.versionNode && StringUtils.isBlank(this.version)) {
                this.version = new String(ch, start, length);
            }
        }

        public String getVersion() {
            return this.version;
        }
    }
}

