/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.enums;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public enum DataFormat {
    POS("dat"),
    CUT("dat"),
    CSV("csv"),
    SQL("sql"),
    ORC("orc"),
    PAR("parquet"),
    AVRO("avro"),
    DDL("sql"),
    MIX("sql");

    private static final DataFormat[] DATA_FORMATS;
    private final String defaultExtension;

    private DataFormat(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    public String getDefaultFileSuffix() {
        if (this == DDL) {
            return "-schema.sql";
        }
        return "." + this.defaultExtension;
    }

    public boolean isBinary() {
        return this == ORC || this == PAR || this == AVRO;
    }

    public boolean isReadable() {
        return this == CUT || this == CSV || this == POS || this == SQL;
    }

    public static String appendSchemaOption() {
        return "[" + Arrays.stream(DATA_FORMATS).filter(f -> f == DDL || f == MIX).map(f -> "--" + f.toString().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(",")) + "]";
    }

    public static String appendRecordOption() {
        return "[" + Arrays.stream(DATA_FORMATS).filter(f -> f != DDL && f != MIX).map(f -> "--" + f.toString().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(",")) + "]";
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    static {
        DATA_FORMATS = DataFormat.values();
    }
}

