/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.enums;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedProductException;
import com.oceanbase.tools.loaddump.common.model.Version;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DbType implements Cloneable
{
    OBMYSQL_14("OBMYSQL", "1.4.x"),
    OBMYSQL_21("OBMYSQL", "2.1.x"),
    OBMYSQL_22("OBMYSQL", "2.2.x"),
    OBMYSQL_3X("OBMYSQL", "3.x"),
    OBMYSQL_200("OBMYSQL", "2.0.0"),
    OBMYSQL_211("OBMYSQL", "2.1.1"),
    OBMYSQL_2210("OBMYSQL", "2.2.10"),
    OBMYSQL_2230("OBMYSQL", "2.2.30"),
    OBMYSQL_2250("OBMYSQL", "2.2.50"),
    OBMYSQL_2271("OBMYSQL", "2.2.71"),
    OBMYSQL_322("OBMYSQL", "3.2.2"),
    OBMYSQL_323("OBMYSQL", "3.2.3.0"),
    OBMYSQL_40("OBMYSQL", "4.0.0.0"),
    OBMYSQL_4100("OBMYSQL", "4.1.0.0"),
    OBORACLE_21("OBORACLE", "2.1.x"),
    OBORACLE_22("OBORACLE", "2.2.x"),
    OBORACLE_3X("OBORACLE", "3.x"),
    OBORACLE_2220("OBORACLE", "2.2.20"),
    OBORACLE_2230("OBORACLE", "2.2.30"),
    OBORACLE_2250("OBORACLE", "2.2.50"),
    OBORACLE_2270("OBORACLE", "2.2.70"),
    OBORACLE_2271("OBORACLE", "2.2.71"),
    OBORACLE_2272("OBORACLE", "2.2.72"),
    OBORACLE_2273("OBORACLE", "2.2.73"),
    OBORACLE_310("OBORACLE", "3.1.0"),
    OBORACLE_312("OBORACLE", "3.1.2"),
    OBORACLE_320("OBORACLE", "3.2.0"),
    OBORACLE_322("OBORACLE", "3.2.2"),
    OBORACLE_40("OBORACLE", "4.0.0.0"),
    OBORACLE_4220("OBORACLE", "4.2.2.0");

    private static final Logger log;
    private static final String REGEX_STRING = "[1-9]{1}\\.[0-9]{1,2}\\.(.)+";
    private static final String OB_DIRVER_CLASS = "com.oceanbase.jdbc.Driver";
    private static final Map<String, DbType> DBTYPEMAP;
    private static final Map<String, String> DRIVER_CLASS_MAP;
    private static final TreeMap<String, DbType> OBMYSQL_VERSIONS_MAP;
    private static final TreeMap<String, DbType> OBORACLE_VERSIONS_MAP;
    private static final Map<String, String> OCEANBASE_CE_MAPPING;
    private final String type;
    private final String version;
    private Version realVersion;

    private DbType(String type, String version) {
        this.type = type;
        this.version = version;
        this.realVersion = new Version(version);
    }

    public static DbType valueOf(String type, String version) {
        Preconditions.checkArgument((!StringUtils.isBlank(type) ? 1 : 0) != 0, (Object)"The type is null");
        Preconditions.checkArgument((!StringUtils.isBlank(version) ? 1 : 0) != 0, (Object)"The version is null");
        String realVersion = version.trim();
        String upperType = type.toUpperCase(Locale.getDefault()).trim();
        Optional<DbType> optional = DBTYPEMAP.values().stream().filter(t -> upperType.equals(t.getType()) && version.startsWith(t.getVersion())).findFirst();
        DbType dbType = optional.orElse(null);
        if (dbType == null && version.matches(REGEX_STRING) && Sets.newHashSet((Object[])new String[]{"MYSQL", "ORACLE", "OBMYSQL", "OBORACLE"}).contains(upperType)) {
            String floorKey;
            String newType;
            String string = newType = upperType.startsWith("OB") ? upperType : "OB" + upperType;
            if (OBMYSQL_14.getType().equalsIgnoreCase(newType) && (floorKey = OBMYSQL_VERSIONS_MAP.floorKey(OCEANBASE_CE_MAPPING.getOrDefault(version, version))) != null) {
                dbType = OBMYSQL_VERSIONS_MAP.get(floorKey);
                log.debug("Return the latest compatible version: {} -> {}", (Object)version, (Object)floorKey);
            }
            if (OBORACLE_22.getType().equalsIgnoreCase(newType) && (floorKey = OBORACLE_VERSIONS_MAP.floorKey(version)) != null) {
                dbType = OBORACLE_VERSIONS_MAP.get(floorKey);
                log.debug("Return the latest compatible version: {} -> {}", (Object)version, (Object)floorKey);
            }
            if (dbType == null) {
                String newVersion = version.substring(0, version.lastIndexOf(46) + 1) + "x";
                dbType = DBTYPEMAP.get(newType + "_" + newVersion);
            }
        }
        if (dbType == null) {
            throw new UnsupportedProductException("Invoke DbType.valueOf failed. The product: " + upperType + "_" + version + " is unsupported");
        }
        dbType.setRealVersion(new Version(realVersion));
        return dbType;
    }

    public boolean isPrior(DbType dbType) {
        this.checkNonDiff(dbType);
        return this.isPrior(dbType, dbType.getRealVersion());
    }

    public boolean isPriorFrom(DbType dbType) {
        return this.isSame(dbType) || this.isPrior(dbType);
    }

    public boolean isPrior(DbType dbType, Version version) {
        this.checkNonDiff(dbType);
        return this.getRealVersion().isOlderThan(version);
    }

    public boolean isSame(DbType dbType) {
        this.checkNonDiff(dbType);
        return this.isSame(dbType, dbType.getRealVersion());
    }

    public boolean isSame(DbType dbType, Version version) {
        this.checkNonDiff(dbType);
        return this.getRealVersion().equals(version);
    }

    public boolean isSubsequent(DbType dbType) {
        this.checkNonDiff(dbType);
        return this.isSubsequent(dbType, dbType.getRealVersion());
    }

    public boolean isSubsequentFrom(DbType dbType) {
        return this.isSame(dbType) || this.isSubsequent(dbType);
    }

    public boolean isSubsequent(DbType dbType, Version version) {
        this.checkNonDiff(dbType);
        return this.getRealVersion().isNewerThan(version);
    }

    public String getIdentifier() {
        return this.getType() + "_" + this.getVersion();
    }

    public String toString() {
        return this.getIdentifier() + "(" + this.getRealVersion() + ")";
    }

    public boolean isMySqlType() {
        return OBMYSQL_21.getType().equals(this.getType());
    }

    private void checkNonDiff(DbType dbType) {
        Preconditions.checkArgument((dbType != null ? 1 : 0) != 0, (Object)"The dbtype is null");
        Preconditions.checkArgument((boolean)this.getType().equals(dbType.getType()), (Object)"The version cannot be compared as dbtype is different");
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setRealVersion(Version realVersion) {
        this.realVersion = realVersion;
    }

    public Version getRealVersion() {
        return this.realVersion;
    }

    static {
        log = LoggerFactory.getLogger(DbType.class);
        DBTYPEMAP = new HashMap<String, DbType>();
        DRIVER_CLASS_MAP = new HashMap<String, String>();
        OBMYSQL_VERSIONS_MAP = new TreeMap();
        OBORACLE_VERSIONS_MAP = new TreeMap();
        OCEANBASE_CE_MAPPING = new LinkedHashMap<String, String>();
        OCEANBASE_CE_MAPPING.put("3.1.3-OceanBase CE", "3.2.2");
        for (DbType dbType : DbType.values()) {
            DBTYPEMAP.put(dbType.getIdentifier(), dbType);
        }
        DRIVER_CLASS_MAP.put("OBMYSQL", OB_DIRVER_CLASS);
        DRIVER_CLASS_MAP.put("OBORACLE", OB_DIRVER_CLASS);
        OBMYSQL_VERSIONS_MAP.put("2.0.0", OBMYSQL_200);
        OBMYSQL_VERSIONS_MAP.put("2.1.0", OBMYSQL_21);
        OBMYSQL_VERSIONS_MAP.put("2.1.1", OBMYSQL_211);
        OBMYSQL_VERSIONS_MAP.put("2.2.10", OBMYSQL_2210);
        OBMYSQL_VERSIONS_MAP.put("2.2.30", OBMYSQL_2230);
        OBMYSQL_VERSIONS_MAP.put("2.2.50", OBMYSQL_2250);
        OBMYSQL_VERSIONS_MAP.put("2.2.71", OBMYSQL_2271);
        OBMYSQL_VERSIONS_MAP.put("3.2.2", OBMYSQL_322);
        OBMYSQL_VERSIONS_MAP.put("3.2.3.0", OBMYSQL_323);
        OBMYSQL_VERSIONS_MAP.put("4.0.0.0", OBMYSQL_40);
        OBORACLE_VERSIONS_MAP.put("2.2.20", OBORACLE_2220);
        OBORACLE_VERSIONS_MAP.put("2.2.30", OBORACLE_2230);
        OBORACLE_VERSIONS_MAP.put("2.2.50", OBORACLE_2250);
        OBORACLE_VERSIONS_MAP.put("2.2.70", OBORACLE_2270);
        OBORACLE_VERSIONS_MAP.put("2.2.71", OBORACLE_2271);
        OBORACLE_VERSIONS_MAP.put("2.2.72", OBORACLE_2272);
        OBORACLE_VERSIONS_MAP.put("4.0.0.0", OBORACLE_40);
    }
}

