/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.enums;

import java.text.NumberFormat;

public class LoadStatus {
    public volatile boolean merging;
    public volatile double memUsedRatio;
    private String leaderServer = "0.0.0.0";
    private volatile double slowInsertThreshold = 0.75;
    private volatile double pauseInsertThreshold = 0.85;

    public LoadStatus(boolean merging, double memUsedRatio) {
        this.merging = merging;
        this.memUsedRatio = memUsedRatio;
    }

    public LoadStatus(double slowThreshold, double pauseThreshold) {
        this(false, slowThreshold, pauseThreshold);
    }

    public LoadStatus(boolean merging, double slowThreshold, double pauseThreshold) {
        this.merging = merging;
        this.memUsedRatio = 0.0;
        this.slowInsertThreshold = Math.min(slowThreshold, 0.75);
        this.pauseInsertThreshold = Math.min(pauseThreshold, 0.85);
    }

    public String getMemUsedPercent() {
        return NumberFormat.getPercentInstance().format(this.getMemUsedRatio());
    }

    public LoadMode getLoadMode() {
        double memUsedRatio = this.getMemUsedRatio();
        if (Double.valueOf(0.0).equals(memUsedRatio)) {
            return LoadMode.INIT;
        }
        if (memUsedRatio >= this.getPauseInsertThreshold()) {
            return LoadMode.PAUSE;
        }
        if (this.isMerging() || memUsedRatio >= this.getSlowInsertThreshold()) {
            return LoadMode.SLOW;
        }
        return LoadMode.FAST;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Leader Server: ").append(this.leaderServer);
        sb.append(", Merging: ").append(this.merging);
        sb.append(", Mem Used Ratio: ").append(this.memUsedRatio);
        sb.append(", Slow Threshold: ").append(this.slowInsertThreshold);
        sb.append(", Pause Threshold: ").append(this.pauseInsertThreshold);
        sb.append(", Load Mode: ").append((Object)this.getLoadMode());
        return sb.toString();
    }

    public void setMerging(boolean merging) {
        this.merging = merging;
    }

    public boolean isMerging() {
        return this.merging;
    }

    public void setMemUsedRatio(double memUsedRatio) {
        this.memUsedRatio = memUsedRatio;
    }

    public double getMemUsedRatio() {
        return this.memUsedRatio;
    }

    public void setLeaderServer(String leaderServer) {
        this.leaderServer = leaderServer;
    }

    public String getLeaderServer() {
        return this.leaderServer;
    }

    public double getSlowInsertThreshold() {
        return this.slowInsertThreshold;
    }

    public void setSlowInsertThreshold(double slowInsertThreshold) {
        this.slowInsertThreshold = slowInsertThreshold;
    }

    public double getPauseInsertThreshold() {
        return this.pauseInsertThreshold;
    }

    public void setPauseInsertThreshold(double pauseInsertThreshold) {
        this.pauseInsertThreshold = pauseInsertThreshold;
    }

    public static enum LoadMode {
        INIT,
        FAST,
        SLOW,
        PAUSE;


        public boolean isInit() {
            return INIT.equals((Object)this);
        }
    }
}

