/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.enums;

import com.oceanbase.tools.loaddump.utils.StringUtils;

public enum StorageType {
    LOCAL_DISK("local", "file"),
    HADOOP_HDFS("hdfs", null),
    AMAZON_S3("s3", "s3a"),
    ALIYUN_OSS("oss", null),
    TENCENT_COS("cos", "cosn"),
    HUAWEI_OBS("obs", null);

    public final String name;
    public final String alias;
    private static final StorageType[] STORAGE_TYPES;

    private StorageType(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public static StorageType of(String storageTypeName) {
        if (StringUtils.isBlank(storageTypeName)) {
            return LOCAL_DISK;
        }
        for (StorageType t : STORAGE_TYPES) {
            if (t.name != null && t.name.equalsIgnoreCase(storageTypeName)) {
                return t;
            }
            if (t.alias == null || !t.alias.equalsIgnoreCase(storageTypeName)) continue;
            return t;
        }
        throw new IllegalArgumentException("Unsupported storage type: " + storageTypeName);
    }

    public boolean isObjectStorage() {
        return this == AMAZON_S3 || this == ALIYUN_OSS || this == TENCENT_COS || this == HUAWEI_OBS;
    }

    public String getName() {
        return this.name;
    }

    static {
        STORAGE_TYPES = StorageType.values();
    }
}

