/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.alipay.oceanbase.rpc.property.Property;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;

public class SessionConfig {
    private static final String ORACLE_TAG = "oracle";
    private static final String MYSQL_TAG = "mysql";
    private static final Set<String> JDBC_SECURE_PARAMETERS = Sets.newHashSet((Object[])new String[]{"useSSL", "requireSSL", "disableSslHostnameVerification", "trustStore", "trustStorePassword", "keyStore", "keyStorePassword"});
    @JsonProperty(value="init_sql")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, List<String>> initSql = new HashMap<String, List<String>>();
    @JsonProperty(value="jdbc_url_options")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> jdbcUrlOptions = new HashMap<String, String>();
    @JsonProperty(value="jdbc_hamode")
    private String jdbcHamode;
    @JsonProperty(value="direct_path_load")
    private DirectPathConfig directPathLoad;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SessionConfig fromJson(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (FileInputStream fis = new FileInputStream(file);){
            SessionConfig sessionConfig = (SessionConfig)new ObjectMapper().readValue((InputStream)fis, SessionConfig.class);
            return sessionConfig;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Parse session configuration file failed. Error: ", e);
        }
    }

    @NonNull
    public List<String> getInitSql4Oracle() {
        return Optional.ofNullable(this.initSql).map(t -> (List)t.get(ORACLE_TAG)).orElse(new ArrayList());
    }

    @NonNull
    public List<String> getInitSql4Mysql() {
        return Optional.ofNullable(this.initSql).map(t -> (List)t.get(MYSQL_TAG)).orElse(new ArrayList());
    }

    @NonNull
    public String getJdbcUrlOptionsString() {
        if (MapUtils.isEmpty(this.jdbcUrlOptions)) {
            return "";
        }
        this.handleJdbcSecureOptions();
        return "?" + this.jdbcUrlOptions.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
    }

    private void handleJdbcSecureOptions() {
        block17: {
            if ("true".equalsIgnoreCase(this.getJdbcOptionByKey("useSSL"))) {
                String trustStore = this.getJdbcOptionByKey("trustStore");
                Preconditions.checkArgument((trustStore != null ? 1 : 0) != 0, (Object)"trustStore is undefined in session.config.json");
                String trustStorePassword = this.getJdbcOptionByKey("trustStorePassword");
                Preconditions.checkArgument((trustStorePassword != null ? 1 : 0) != 0, (Object)"trustStorePassword is undefined in session.config.json");
                if (trustStore.startsWith("http://") || trustStore.startsWith("https://")) {
                    try (InputStream is = new URL(trustStore).openStream();){
                        Preconditions.checkArgument((is.available() > 0 ? 1 : 0) != 0, (String)"trustStore: \"%s\" is not exists", (Object)trustStore);
                        break block17;
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("trustStore: \"" + trustStore + "\" is not exists");
                    }
                }
                Preconditions.checkArgument((boolean)FileUtils.exists(trustStore), (String)"trustStore: \"%s\" is not exists", (Object)trustStore);
                System.setProperty("javax.net.ssl.trustStore", trustStore);
                System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
            } else {
                JDBC_SECURE_PARAMETERS.forEach(key -> this.jdbcUrlOptions.remove(key));
            }
        }
    }

    @Nullable
    public String getJdbcOptionByKey(String key) {
        return this.jdbcUrlOptions.get(key);
    }

    public synchronized void setJdbcOption(String key, String value) {
        this.jdbcUrlOptions.put(key, value);
    }

    public synchronized void addInitSql4Mysql(String sql) {
        this.initSql.computeIfAbsent(MYSQL_TAG, key -> new ArrayList()).add(sql);
    }

    public synchronized void addInitSql4Oracle(String sql) {
        this.initSql.computeIfAbsent(ORACLE_TAG, key -> new ArrayList()).add(sql);
    }

    public synchronized void addInitSql4Both(String sql) {
        this.initSql.computeIfAbsent(MYSQL_TAG, key -> new ArrayList()).add(sql);
        this.initSql.computeIfAbsent(ORACLE_TAG, key -> new ArrayList()).add(sql);
    }

    public boolean useOracleStreamResultSet() {
        return this.jdbcUrlOptions != null && "true".equalsIgnoreCase(this.jdbcUrlOptions.get("extendOracleResultSetClass"));
    }

    public String getJdbcHamode() {
        return this.jdbcHamode;
    }

    public DirectPathConfig getDirectPathLoad() {
        return this.directPathLoad;
    }

    public static class DirectPathConfig {
        @JsonProperty(value="rpc_connect_timeout")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private int rpcConnectTimeout;
        @JsonProperty(value="rpc_execute_timeout")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private int rpcExecuteTimeout;
        @JsonProperty(value="runtime_retry_times")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private int runtimeRetryTimes;
        @JsonProperty(value="runtime_retry_intervals")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private int runtimeRetryIntervals;
        @JsonProperty(value="task_timeout")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private long taskTimeout;
        @JsonProperty(value="heartbeat_timeout")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private long heartbeatTimeout;

        public Properties toDirectPathProperty() {
            Properties props = new Properties();
            props.setProperty(Property.RPC_CONNECT_TIMEOUT.getKey(), String.valueOf(this.getRpcConnectTimeout()));
            props.setProperty(Property.RPC_EXECUTE_TIMEOUT.getKey(), String.valueOf(this.getRpcExecuteTimeout()));
            props.setProperty(Property.RUNTIME_RETRY_TIMES.getKey(), String.valueOf(this.getRuntimeRetryTimes()));
            props.setProperty(Property.RUNTIME_RETRY_INTERVAL.getKey(), String.valueOf(this.getRuntimeRetryIntervals()));
            return props;
        }

        public int getRpcConnectTimeout() {
            return this.rpcConnectTimeout;
        }

        public int getRpcExecuteTimeout() {
            return this.rpcExecuteTimeout;
        }

        public int getRuntimeRetryTimes() {
            return this.runtimeRetryTimes;
        }

        public int getRuntimeRetryIntervals() {
            return this.runtimeRetryIntervals;
        }

        public long getTaskTimeout() {
            return this.taskTimeout;
        }

        public long getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }
    }
}

