/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.model.ObjectStatus;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.tablefmt.Table;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.MapUtils;

public class Summary
implements Serializable {
    private static final long serialVersionUID = -4511681073203866664L;
    private final String header;
    private final Collection<TaskDetail> taskDetails;
    private final List<ObjectStatus> objectStatusList = new ArrayList<ObjectStatus>();

    public Summary(String header, Collection<TaskDetail> taskDetails) {
        this.header = header;
        if (taskDetails == null) {
            taskDetails = new ArrayList<TaskDetail>();
        }
        this.taskDetails = Collections.unmodifiableCollection(taskDetails);
        this.initObjectStatusList();
    }

    private void initObjectStatusList() {
        if (CollectionUtils.isEmpty(this.taskDetails)) {
            return;
        }
        HashMap<String, ObjectStatus> group = new HashMap<String, ObjectStatus>();
        for (TaskDetail taskDetail : this.taskDetails) {
            TaskType taskType = taskDetail.getTaskType();
            if (taskType == TaskType.DUMP_SCHEMA || taskType == TaskType.LOAD_SCHEMA) {
                this.objectStatusList.addAll(taskDetail.getObjectStatusList());
                continue;
            }
            String objectName = taskDetail.getObject();
            ObjectStatus objectStatus = group.computeIfAbsent(objectName, v -> new ObjectStatus());
            objectStatus.setName(objectName);
            objectStatus.setType(taskDetail.getType());
            objectStatus.addTotal(taskDetail.getTotal());
            objectStatus.addCount(taskDetail.getCount());
            objectStatus.and(taskDetail.getState());
        }
        if (MapUtils.isNotEmpty(group)) {
            this.objectStatusList.addAll(group.values());
        }
    }

    public String toHumanReadableFormat() {
        long totalCount = 0L;
        StringBuilder sb = new StringBuilder(8192);
        sb.append("\n\n").append(this.header).append(": \n\n");
        if (CollectionUtils.isEmpty(this.objectStatusList)) {
            sb.append((CharSequence)this.createTable().render());
            sb.append("\n\n");
            sb.append(String.format("\n%65s", "Nothing was done!"));
            sb.append("\n\n");
            sb.append("--------------------------------------------------------------");
            sb.append("--------------------------------------------------------------");
        } else {
            long count;
            long total;
            Table table;
            TreeMap<String, Map> successGroup = new TreeMap<String, Map>();
            TreeMap<String, Map> failureGroup = new TreeMap<String, Map>();
            for (ObjectStatus objectStatus : this.objectStatusList) {
                ObjectStatus beforeStatus;
                String objectType = objectStatus.getType();
                String objectName = objectStatus.getName();
                if (ObjectStatus.Status.SUCCESS.equals((Object)objectStatus.getStatus())) {
                    Map successMap = successGroup.getOrDefault(objectType, new HashMap());
                    beforeStatus = (ObjectStatus)successMap.get(objectName);
                    if (beforeStatus != null) {
                        beforeStatus.addCount(objectStatus.getCount().get());
                        beforeStatus.addTotal(objectStatus.getTotal().get());
                    }
                    successMap.putIfAbsent(objectName, objectStatus);
                    successGroup.putIfAbsent(objectType, successMap);
                    continue;
                }
                Map failureMap = failureGroup.getOrDefault(objectType, new HashMap());
                beforeStatus = (ObjectStatus)failureMap.get(objectName);
                if (beforeStatus != null) {
                    beforeStatus.addCount(objectStatus.getCount().get());
                    beforeStatus.addTotal(objectStatus.getTotal().get());
                }
                failureMap.putIfAbsent(objectName, objectStatus);
                failureGroup.putIfAbsent(objectType, failureMap);
            }
            if (MapUtils.isNotEmpty(successGroup)) {
                int success = 1;
                table = this.createTable();
                for (Map successMap : successGroup.values()) {
                    for (ObjectStatus objectStatus : successMap.values()) {
                        table.addCell(String.valueOf(success++));
                        table.addCell(objectStatus.getType());
                        table.addCell(objectStatus.getName());
                        total = objectStatus.getTotal().get();
                        count = objectStatus.getCount().get();
                        if (total == 0L) {
                            table.addCell(String.valueOf(count));
                        } else {
                            table.addCell(total + " -> " + count);
                        }
                        table.addCell(objectStatus.getStatus().name());
                        totalCount += objectStatus.getCount().get();
                    }
                }
                sb.append((CharSequence)table.render());
            }
            if (MapUtils.isNotEmpty(failureGroup)) {
                int failure = 1;
                table = this.createTable();
                sb.append("\n\n");
                for (Map failureMap : failureGroup.values()) {
                    for (ObjectStatus objectStatus : failureMap.values()) {
                        table.addCell(String.valueOf(failure++));
                        table.addCell(objectStatus.getType());
                        table.addCell(objectStatus.getName());
                        total = objectStatus.getTotal().get();
                        count = objectStatus.getCount().get();
                        if (total == 0L) {
                            table.addCell(String.valueOf(count));
                        } else {
                            table.addCell(total + " -> " + count);
                        }
                        table.addCell(objectStatus.getStatus().name());
                        totalCount += objectStatus.getCount().get();
                    }
                }
                sb.append((CharSequence)table.render());
            }
        }
        String endTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        sb.append(String.format("\n\nTotal Count: %d\t\tEnd Time: %s", totalCount, endTime));
        return sb.append("\n\n").toString();
    }

    public String toString() {
        return this.toHumanReadableFormat();
    }

    private Table createTable() {
        Table table = new Table(5);
        table.setColumnWidth(0, 20, 30);
        table.setColumnWidth(1, 20, 30);
        table.setColumnWidth(2, 30, 100);
        table.setColumnWidth(3, 30, 60);
        table.setColumnWidth(4, 20, 20);
        table.addCell(" No.# ");
        table.addCell(" Type ");
        table.addCell(" Name ");
        table.addCell(" Count ");
        table.addCell(" Status ");
        return table;
    }

    public List<ObjectStatus> getObjectStatusList() {
        return this.objectStatusList;
    }
}

