/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.oceanbase.partition.calculator.enums.ObPartLevel;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.metadata.desc.ObTablePart;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;

public class TableEntryInfo {
    private boolean emptyTable;
    private TableEntry tableEntry;
    private Map<Long, String> leaderMap;
    private Map<String, Set<String>> partToSubPartMaps;
    private List<String> partNames;
    private List<String> subPartNames;
    private ObPartLevel partLevel;
    private List<String> splitKeyColumns;

    public TableEntryInfo() {
        this(false);
    }

    public TableEntryInfo(boolean emptyTable) {
        this.emptyTable = emptyTable;
        this.splitKeyColumns = new ArrayList<String>();
    }

    public void setTableEntry(TableEntry tableEntry) {
        this.tableEntry = tableEntry;
        ObTablePart tablePart = tableEntry.getTablePart();
        if (tablePart == null) {
            this.partLevel = ObPartLevel.LEVEL_ZERO;
            return;
        }
        this.partLevel = tablePart.getLevel();
        this.partNames = new ArrayList(tablePart.getPartDesc().getPartNameIdMap().keySet());
        if (tablePart.getLevel() == ObPartLevel.LEVEL_TWO) {
            boolean isUseTemplateInOB3X;
            this.subPartNames = new ArrayList(tablePart.getSubPartDesc().getPartNameIdMap().keySet());
            boolean bl = isUseTemplateInOB3X = !tableEntry.getServerMode().isSubsequentFrom("4.0.0.0") && tablePart.getSubPartDesc().isUseTemplate();
            if (isUseTemplateInOB3X) {
                this.subPartNames = this.partNames.stream().flatMap(partName -> this.subPartNames.stream().map(subPartName -> partName + "s" + subPartName)).collect(Collectors.toList());
            }
            this.partToSubPartMaps = this.partNames.stream().collect(Collectors.toMap(Function.identity(), name -> {
                long partId = (Long)tablePart.getPartDesc().getPartNameIdMap().get(name);
                Map partIdSubNamesMap = tablePart.getSubPartDesc().getPartIdSubNamesMap();
                if (MapUtils.isEmpty((Map)partIdSubNamesMap)) {
                    Preconditions.checkState((boolean)isUseTemplateInOB3X, (Object)"Invalid state. No sub partition mapping found.");
                    return tablePart.getSubPartDesc().getPartNameIdMap().keySet().stream().map(t -> name + "s" + t).collect(Collectors.toSet());
                }
                return Sets.newHashSet((Iterable)((Iterable)partIdSubNamesMap.get(partId)));
            }));
        }
    }

    public boolean isEmptyTable() {
        return this.emptyTable;
    }

    public void setEmptyTable(boolean emptyTable) {
        this.emptyTable = emptyTable;
    }

    public TableEntry getTableEntry() {
        return this.tableEntry;
    }

    public Map<Long, String> getLeaderMap() {
        return this.leaderMap;
    }

    public void setLeaderMap(Map<Long, String> leaderMap) {
        this.leaderMap = leaderMap;
    }

    public Map<String, Set<String>> getPartToSubPartMaps() {
        return this.partToSubPartMaps;
    }

    public void setPartToSubPartMaps(Map<String, Set<String>> partToSubPartMaps) {
        this.partToSubPartMaps = partToSubPartMaps;
    }

    public List<String> getPartNames() {
        return this.partNames;
    }

    public void setPartNames(List<String> partNames) {
        this.partNames = partNames;
    }

    public List<String> getSubPartNames() {
        return this.subPartNames;
    }

    public void setSubPartNames(List<String> subPartNames) {
        this.subPartNames = subPartNames;
    }

    public ObPartLevel getPartLevel() {
        return this.partLevel;
    }

    public void setPartLevel(ObPartLevel partLevel) {
        this.partLevel = partLevel;
    }

    public List<String> getSplitKeyColumns() {
        return this.splitKeyColumns;
    }

    public void setSplitKeyColumns(List<String> splitKeyColumns) {
        this.splitKeyColumns = splitKeyColumns;
    }
}

