/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.constants.JdbcType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.ColumnInfo;
import com.oceanbase.tools.loaddump.common.model.GeometryObject;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.factory.TypeHandlerFactory;
import com.oceanbase.tools.loaddump.function.generation.AbstractGeneratedDefine;
import com.oceanbase.tools.loaddump.function.generation.sequence.DatabaseSequence;
import com.oceanbase.tools.loaddump.mybatis.type.TypeHandler;
import com.oceanbase.tools.loaddump.parser.record.Record;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.vmoption.JavaOpts;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableInfo
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TableInfo.class);
    private static final long serialVersionUID = 535985870192322263L;
    private final List<Integer> primaryLogicOffsets = new ArrayList<Integer>(16);
    private final List<String> primaryColumnNames = new ArrayList<String>(16);
    private final List<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>(16);
    private final Map<String, Boolean> nullableMap = new LinkedHashMap<String, Boolean>(16);
    private final List<String> virtualColumnList = new ArrayList<String>(16);
    private final Map<String, Boolean> quotaFlagMap = new LinkedHashMap<String, Boolean>(16);
    private final Map<String, Boolean> escapeFlagMap = new LinkedHashMap<String, Boolean>(16);
    private final Map<String, Object> columnTypeMap = new LinkedHashMap<String, Object>(16);
    private final Map<String, MapObject> columnIndexMapping = new LinkedHashMap<String, MapObject>(16);
    private final Map<Integer, String> indexColumnMap = new LinkedHashMap<Integer, String>(16);
    private final Map<String, TypeHandler<?>> typeHandlerMap = new HashMap(16);
    private String schema;
    private String table;
    private transient String schemaTable;
    private ServerMode server;
    private boolean ignoreUnhex;
    private boolean logicalDatabase;
    private boolean emptyTable;
    private boolean withDatafiles;
    private boolean dumpOperation;
    private boolean hiddenPrimaryKeyEnabled;
    private boolean excludeVirtualColumns;
    private String[] csvHeaders;
    private StringBuilder insertPrefix;
    private StringBuilder replacePrefix;
    private transient String selectColumns;
    private transient String insertColumns;
    private Map<Integer, String> rowKeyMap;
    private List<String> primaryCols;
    private Map<String, List<String>> uniqueKeyMap;
    private Map<String, List<String>> notNullUniqueKeyMap;
    private final Cache<String, String> INSERT_INTO_STMT_CACHE = CacheBuilder.newBuilder().initialCapacity(64).maximumSize(100000L).concurrencyLevel(Constants.AVAILABLE_CPUS).expireAfterAccess(30L, TimeUnit.SECONDS).build();
    private final Cache<String, String> MERGE_INTO_STMT_CACHE = CacheBuilder.newBuilder().initialCapacity(64).maximumSize(100000L).concurrencyLevel(Constants.AVAILABLE_CPUS).expireAfterAccess(30L, TimeUnit.SECONDS).build();

    public TableInfo(ServerMode serverMode, String schemaName, String tableName) {
        this(serverMode, schemaName, tableName, Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap(), false);
    }

    public TableInfo(ServerMode serverMode, String schemaName, String tableName, Map<String, ColumnInfo> columnMap, Map<String, MapObject> columnIndexMap, Map<String, TypeHandler<?>> typeHandlerMap, boolean isDumpOperation) {
        this.server = serverMode;
        this.schema = schemaName;
        this.table = tableName;
        this.dumpOperation = isDumpOperation;
        this.typeHandlerMap.putAll(typeHandlerMap);
        this.initializeTableInfoMetadata(columnMap, columnIndexMap);
        if (this.dumpOperation) {
            this.initializeBasicsForDumpling();
        } else {
            this.initializeBasicsForLoading();
        }
        this.schemaTable = this.server.wrapName(this.schema) + "." + this.server.wrapName(this.table);
        this.csvHeaders = (String[])this.columnInfoList.stream().map(ColumnInfo::getColumnName).toArray(String[]::new);
    }

    public void resetTableInfo(ResultSet rs, ServerMode serverMode, boolean isUseRunTimeName, boolean preserveZeroDatetime) throws SQLException {
        this.server = serverMode;
        boolean isMySqlMode = ServerMode.MYSQL.equals((Object)serverMode);
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            String columnName = isUseRunTimeName ? rsmd.getColumnName(i + 1) : rsmd.getColumnLabel(i + 1);
            String dataType = rsmd.getColumnTypeName(i + 1);
            dataType = dataType == null ? "VARCHAR".toLowerCase(Locale.getDefault()) : dataType.toLowerCase(Locale.getDefault());
            ColumnInfo columnInfo = new ColumnInfo(columnName, dataType, i);
            columnInfo.setSchemaName(rsmd.getCatalogName(i + 1));
            columnInfo.setTableName(rsmd.getTableName(i + 1));
            this.fillingColumnInfoMetadata(columnInfo);
            this.columnIndexMapping.put(columnName, new MapObject(i, i));
            this.typeHandlerMap.put(columnName, TypeHandlerFactory.createTypeHandler(dataType, isMySqlMode, preserveZeroDatetime));
        }
        this.initializeBasicsForDumpling();
    }

    private void initializeTableInfoMetadata(@NonNull Map<String, ColumnInfo> columnInfoMap, Map<String, MapObject> columnIndexMap) {
        if (columnInfoMap == null) {
            throw new NullPointerException("columnInfoMap is marked non-null but is null");
        }
        Collection<ColumnInfo> columnInfos = columnInfoMap.values();
        if (MapUtils.isNotEmpty(columnIndexMap)) {
            int logicOffset = 0;
            for (Map.Entry<String, MapObject> entry : columnIndexMap.entrySet()) {
                for (ColumnInfo columnInfo : columnInfos) {
                    if (!columnInfo.getColumnName().equals(entry.getKey())) continue;
                    MapObject mapObj = entry.getValue();
                    if (mapObj.getSource() == null && (this.dumpOperation || mapObj.getGeneratedDefine() == null)) {
                        mapObj.setSource(logicOffset++);
                    }
                    this.fillingColumnInfoMetadata(columnInfo);
                }
            }
            Preconditions.checkState((!this.columnInfoList.isEmpty() ? 1 : 0) != 0, (String)"No columns selected for the table \"%s\". Your selection: %s.\n-\tNOTE: Ensure column names are correctly spelled.\n-\tIf not typo, it may caused by case sensitivity settings of database. Try enclosing the column names in square brackets to resolve the error.", (Object)this.table, columnIndexMap.keySet());
        } else {
            int logicOffset = 0;
            for (ColumnInfo columnInfo : columnInfos) {
                columnIndexMap.put(columnInfo.getColumnName(), new MapObject(logicOffset++, columnInfo.getColumnPosition()));
                this.fillingColumnInfoMetadata(columnInfo);
            }
        }
        this.columnIndexMapping.putAll(columnIndexMap);
    }

    private void fillingColumnInfoMetadata(ColumnInfo columnInfo) {
        String columnName = columnInfo.getColumnName();
        Object dataType = columnInfo.getDataType();
        Integer physicOffset = columnInfo.getColumnPosition();
        this.columnInfoList.add(columnInfo);
        this.columnTypeMap.put(columnName, dataType);
        this.indexColumnMap.put(physicOffset, columnName);
        this.nullableMap.put(columnName, columnInfo.isNullable());
        if (columnInfo.isVirtual()) {
            this.virtualColumnList.add(columnName);
        }
        this.quotaFlagMap.put(columnName, this.server.isNeedQuote(dataType.toString()));
        this.escapeFlagMap.put(columnName, this.server.isNeedEscape(dataType.toString()));
    }

    private void initializeBasicsForDumpling() {
        this.selectColumns = this.buildSelectColumns();
        String table = this.server.wrapName(this.table);
        String insertColumns = this.buildInsertColumns();
        int capacity = 16 + table.length() + insertColumns.length();
        this.insertPrefix = new StringBuilder(capacity).append("INSERT INTO ").append(table).append(" (").append(insertColumns).append(")");
        if (JavaOpts.isBackupRestoreMode && this.hiddenPrimaryKeyEnabled) {
            this.selectColumns = this.selectColumns + "," + this.server.wrapName("__pk_increment");
            int size = this.columnIndexMapping.size();
            ColumnInfo columnInfo = new ColumnInfo("__pk_increment", "BIGINT".toLowerCase(Locale.getDefault()), false, size);
            this.fillingColumnInfoMetadata(columnInfo);
            this.columnIndexMapping.put("__pk_increment", new MapObject(size, size));
            this.csvHeaders = (String[])this.columnInfoList.stream().map(ColumnInfo::getColumnName).toArray(String[]::new);
        }
    }

    private void initializeBasicsForLoading() {
        String table = this.server.wrapName(this.table);
        String insertColumns = this.buildInsertColumns();
        int capacity = 16 + table.length() + insertColumns.length();
        this.insertPrefix = new StringBuilder(capacity).append("INSERT INTO ").append(table).append(" (").append(insertColumns).append(")");
        this.replacePrefix = new StringBuilder(capacity).append("REPLACE INTO ").append(table).append(" (").append(insertColumns).append(")");
    }

    private String buildSelectColumns() {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.selectColumns)) {
            return this.selectColumns;
        }
        StringBuilder sb = new StringBuilder(this.columnInfoList.size() * 32);
        for (ColumnInfo columnInfo : this.columnInfoList) {
            String columnName = columnInfo.getColumnName();
            if (this.excludeVirtualColumns && this.isVirtualColumn(columnName)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.server.wrapName(columnName));
        }
        this.selectColumns = sb.toString();
        return this.selectColumns;
    }

    private String buildInsertColumns() {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.insertColumns)) {
            return this.insertColumns;
        }
        StringBuilder sb = new StringBuilder(this.columnInfoList.size() * 32);
        for (ColumnInfo columnInfo : this.columnInfoList) {
            String columnName = columnInfo.getColumnName();
            if (this.isVirtualColumn(columnName)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.server.wrapName(columnName));
        }
        this.insertColumns = sb.toString();
        return this.insertColumns;
    }

    public void preparePrimaryForReplace() {
        if (this.primaryLogicOffsets.isEmpty() && CollectionUtils.isNotEmpty(this.primaryCols)) {
            for (int i = 0; i < this.primaryCols.size(); ++i) {
                Integer ordinalPosition = i;
                String columnName = this.primaryCols.get(i);
                Integer logicOffset = this.getLogicOffset(columnName);
                if (logicOffset == null) {
                    log.warn("The logic offset of primary key column: [{},\"{}\"] is null. Maybe the primary key data doesn't exist in the data file.", (Object)ordinalPosition, (Object)columnName);
                    break;
                }
                this.primaryLogicOffsets.add(logicOffset);
                this.primaryColumnNames.add(columnName);
            }
        }
    }

    public Integer getLogicOffset(String columnName) {
        MapObject obj = this.columnIndexMapping.get(columnName);
        return obj == null ? null : obj.getSource();
    }

    public Collection<Integer> getLogicOffsets() {
        return this.columnIndexMapping.values().stream().map(MapObject::getSource).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String cachedInsertIntoSqlStmt(int valueSize, int recordCount) {
        try {
            return (String)this.INSERT_INTO_STMT_CACHE.get((Object)(this.schemaTable + "_" + valueSize + "_" + recordCount), () -> {
                String basicPlaceHolder = "(" + String.join((CharSequence)",", this.assemblePlaceholders(valueSize)) + ")";
                String placeHolder = StringUtils.repeat(basicPlaceHolder, ",", recordCount);
                return this.insertPrefix + " VALUES " + placeHolder;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Get cached sql statement failed. Table: " + this.schemaTable, e);
        }
    }

    public String cachedInsertIntoSqlStmt(Record sampleRecord, int recordCount) {
        if (sampleRecord.isHasGeometryField()) {
            List<String> placeholders = this.assemblePlaceholders(sampleRecord);
            int valueSize = sampleRecord.size();
            try {
                return (String)this.INSERT_INTO_STMT_CACHE.get((Object)(this.schemaTable + "_" + valueSize + "_" + recordCount + "_" + placeholders), () -> {
                    String basicPlaceHolder = "(" + String.join((CharSequence)",", placeholders) + ")";
                    String placeHolder = StringUtils.repeat(basicPlaceHolder, ",", recordCount);
                    return this.insertPrefix + " VALUES " + placeHolder;
                });
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Get cached sql statement failed. Table: " + this.schemaTable, e);
            }
        }
        return this.cachedInsertIntoSqlStmt(sampleRecord.size(), recordCount);
    }

    public String cachedMergeIntoSqlStmt(int valueSize) {
        try {
            return (String)this.MERGE_INTO_STMT_CACHE.get((Object)(this.schemaTable + "_" + valueSize), () -> {
                StringBuilder stmtBuilder = new StringBuilder();
                stmtBuilder.append("MERGE INTO ").append(this.table).append(" USING (SELECT ");
                List columnNameList = this.columnInfoList.stream().filter(c -> !c.isVirtual()).map(ColumnInfo::getColumnName).collect(Collectors.toList());
                List<String> placeholder = this.assemblePlaceholders(valueSize);
                String selectClause = IntStream.range(0, columnNameList.size()).mapToObj(i -> (String)placeholder.get(i) + " AS " + this.server.wrapName((String)columnNameList.get(i))).collect(Collectors.joining(","));
                stmtBuilder.append(selectClause);
                stmtBuilder.append(" FROM dual) DUAL_TABLE ON ");
                String onClause = "(";
                if (CollectionUtils.isNotEmpty(this.primaryCols)) {
                    onClause = onClause + this.primaryCols.stream().map(col -> this.table + "." + col + " = DUAL_TABLE." + col).collect(Collectors.joining(" AND "));
                }
                if (MapUtils.isNotEmpty(this.notNullUniqueKeyMap)) {
                    String condUnique = this.notNullUniqueKeyMap.values().stream().map(colList -> colList.stream().map(col -> this.table + "." + col + " = DUAL_TABLE." + col).collect(Collectors.joining(" AND ", "(", ")"))).collect(Collectors.joining(" OR "));
                    onClause = onClause + " OR " + condUnique;
                }
                onClause = onClause + ")";
                stmtBuilder.append(onClause);
                StringBuilder whenClause = new StringBuilder();
                String updateSetStmt = columnNameList.stream().filter(col -> !this.isVirtualColumn((String)col) && !this.primaryCols.contains(col) && this.notNullUniqueKeyMap.values().stream().noneMatch(colList -> colList.contains(col))).map(col -> this.table + "." + col + " = DUAL_TABLE." + col).collect(Collectors.joining(","));
                String columnString = columnNameList.stream().filter(col -> !this.isVirtualColumn((String)col)).collect(Collectors.joining(",", "(", ")"));
                String assignStmt = columnNameList.stream().filter(col -> !this.isVirtualColumn((String)col)).map(col -> "DUAL_TABLE." + col).collect(Collectors.joining(",", "(", ")"));
                whenClause.append(" WHEN MATCHED THEN UPDATE SET ");
                whenClause.append(updateSetStmt);
                whenClause.append(" WHEN NOT MATCHED THEN INSERT ");
                whenClause.append(columnString).append(" VALUES ").append(assignStmt);
                return stmtBuilder.append((CharSequence)whenClause).toString();
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Get cached `merge into` sql statement failed. Table: " + this.schemaTable, e);
        }
    }

    private List<String> assemblePlaceholders(int valueSize) {
        ArrayList<String> placeHolders = new ArrayList<String>(valueSize);
        for (int logicPosition = 0; logicPosition < valueSize; ++logicPosition) {
            boolean isUseUnhex;
            Integer offset = this.getPhysicOffset(logicPosition);
            if (offset == null || this.isVirtualColumn(logicPosition)) continue;
            String columnName = this.getColumnName(logicPosition);
            String dataType = this.getColumnTypeName(columnName);
            boolean bl = isUseUnhex = this.isMySqlMode() && !this.isIgnoreUnhex();
            if (isUseUnhex && JdbcType.isBinaryType(dataType)) {
                placeHolders.add("unhex(?)");
                continue;
            }
            if ("YEAR".equalsIgnoreCase(dataType)) {
                placeHolders.add("CAST( ? AS UNSIGNED)");
                continue;
            }
            if (this.containsDbSequence(columnName)) {
                DatabaseSequence dbSequence = (DatabaseSequence)this.columnIndexMapping.get(columnName).getGeneratedDefine();
                placeHolders.add(dbSequence.getValue());
                continue;
            }
            placeHolders.add("?");
        }
        return placeHolders;
    }

    private List<String> assemblePlaceholders(Record sampleRecord) {
        int valueSize = sampleRecord.size();
        ArrayList<String> placeHolders = new ArrayList<String>(valueSize);
        for (int logicPosition = 0; logicPosition < valueSize; ++logicPosition) {
            Integer offset = this.getPhysicOffset(logicPosition);
            if (offset == null || this.isVirtualColumn(logicPosition)) continue;
            String columnName = this.getColumnName(logicPosition);
            String dataType = this.getColumnTypeName(columnName);
            boolean isUseUnhex = this.isMySqlMode() && !this.isIgnoreUnhex();
            Object colValueObj = sampleRecord.get(logicPosition);
            if (colValueObj instanceof GeometryObject) {
                boolean hasSRID = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((GeometryObject)colValueObj).getSRID());
                placeHolders.add(hasSRID ? "ST_GeomFromText(?, ?)" : "ST_GeomFromText(?)");
                continue;
            }
            if (isUseUnhex && JdbcType.isBinaryType(dataType)) {
                placeHolders.add("unhex(?)");
                continue;
            }
            if ("YEAR".equalsIgnoreCase(dataType)) {
                placeHolders.add("CAST( ? AS UNSIGNED)");
                continue;
            }
            if (this.containsDbSequence(columnName)) {
                DatabaseSequence dbSequence = (DatabaseSequence)this.columnIndexMapping.get(columnName).getGeneratedDefine();
                placeHolders.add(dbSequence.getValue());
                continue;
            }
            placeHolders.add("?");
        }
        return placeHolders;
    }

    public String getColumnName(int logicPosition) {
        ColumnInfo columnInfo = this.columnInfoList.get(logicPosition);
        Preconditions.checkArgument((columnInfo != null ? 1 : 0) != 0, (String)"The column info is null. (%s:%s)", (Object)this.schemaTable, (int)logicPosition);
        return columnInfo.getColumnName();
    }

    public Object getColumnType(int logicPosition) {
        String columnName = this.getColumnName(logicPosition);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(columnName), (String)"The column name is null. (%s:%s)", (Object)this.schemaTable, (int)logicPosition);
        return this.getColumnType(columnName);
    }

    public Object getColumnType(String columnName) {
        Object columnType = this.columnTypeMap.get(columnName);
        Preconditions.checkArgument((columnType != null ? 1 : 0) != 0, (String)"The column type is null. (%s.%s)", (Object)this.schemaTable, (Object)columnName);
        return columnType;
    }

    public String getColumnTypeName(int logicPosition) {
        return this.getColumnType(logicPosition).toString();
    }

    public String getColumnTypeName(String columnName) {
        return this.getColumnType(columnName).toString();
    }

    public Integer getPhysicOffset(int logicPosition) {
        if (logicPosition >= this.columnInfoList.size()) {
            return null;
        }
        String columnName = this.getColumnName(logicPosition);
        MapObject mapObject = this.columnIndexMapping.get(columnName);
        Preconditions.checkArgument((mapObject != null ? 1 : 0) != 0, (String)"The column map object is null. (%s.%s:%s", (Object)this.schemaTable, (Object)columnName, (Object)logicPosition);
        return mapObject.getTarget();
    }

    @Deprecated
    public boolean isNeedEscape(int logicPosition) {
        Integer physicalOffset = this.getPhysicOffset(logicPosition);
        Preconditions.checkArgument((physicalOffset != null ? 1 : 0) != 0, (String)"The physical offset is null. (%s:%s)", (Object)this.schemaTable, (int)logicPosition);
        return this.isNeedEscape(this.indexColumnMap.get(physicalOffset));
    }

    public boolean isNeedEscape(String columnName) {
        return this.escapeFlagMap.get(columnName);
    }

    @Deprecated
    public boolean isNeedQuote(int logicPosition) {
        Integer physicalOffset = this.getPhysicOffset(logicPosition);
        Preconditions.checkArgument((physicalOffset != null ? 1 : 0) != 0, (String)"The physical offset is null. (%s:%s)", (Object)this.schemaTable, (int)logicPosition);
        return this.isNeedQuote(this.indexColumnMap.get(physicalOffset));
    }

    public boolean isNeedQuote(@NonNull String columnName) {
        if (columnName == null) {
            throw new NullPointerException("columnName is marked non-null but is null");
        }
        return this.quotaFlagMap.get(columnName);
    }

    @Deprecated
    public boolean isNullable(int logicPosition) {
        Integer physicalOffset = this.getPhysicOffset(logicPosition);
        Preconditions.checkArgument((physicalOffset != null ? 1 : 0) != 0, (String)"The physical offset is null. (%s:%s)", (Object)this.schemaTable, (int)logicPosition);
        return this.isNullable(this.indexColumnMap.get(physicalOffset));
    }

    public boolean isNullable(@NonNull String columnName) {
        if (columnName == null) {
            throw new NullPointerException("columnName is marked non-null but is null");
        }
        return this.nullableMap.get(columnName);
    }

    public boolean isMySqlMode() {
        return ServerMode.MYSQL.equals((Object)this.server);
    }

    public boolean isOracleMode() {
        return ServerMode.ORACLE.equals((Object)this.server);
    }

    @Deprecated
    public boolean isVirtualColumn(int logicPosition) {
        return this.isVirtualColumn(this.getColumnName(logicPosition));
    }

    public boolean isVirtualColumn(String columnName) {
        List<String> virtualColumns = this.virtualColumnList;
        return !virtualColumns.isEmpty() && virtualColumns.contains(columnName);
    }

    @Deprecated
    public boolean containsDbSequence(int logicPosition) {
        return this.containsDbSequence(this.getColumnName(logicPosition));
    }

    public boolean containsDbSequence(String columnName) {
        Preconditions.checkArgument((columnName != null ? 1 : 0) != 0, (String)"The column name is null. (%s)", (Object)this.schemaTable);
        MapObject mapObject = this.columnIndexMapping.get(columnName);
        if (mapObject == null) {
            return false;
        }
        AbstractGeneratedDefine generatedDefine = mapObject.getGeneratedDefine();
        return generatedDefine != null && generatedDefine.getType() == 2;
    }

    public TypeHandler<?> getTypeHandler(String columnName) {
        return this.typeHandlerMap.get(columnName);
    }

    public boolean hasPrimaryKey() {
        return !this.primaryLogicOffsets.isEmpty();
    }

    public boolean hasUniqueKey() {
        return this.uniqueKeyMap != null && !this.uniqueKeyMap.isEmpty();
    }

    public void switchToReplaceIntoPrefix() {
        this.insertPrefix = this.replacePrefix;
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.table);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInfo tableInfo = (TableInfo)o;
        return Objects.equals(this.schema, tableInfo.schema) && Objects.equals(this.table, tableInfo.table);
    }

    public String toString() {
        return "TableInfo{schema='" + this.schema + '\'' + ", table='" + this.table + '\'' + '}';
    }

    public StringBuilder toInsertSql(Record record) {
        return new StringBuilder(this.insertPrefix).append(record.toValueClause());
    }

    public TableInfo() {
    }

    public List<String> getPrimaryColumnNames() {
        return this.primaryColumnNames;
    }

    public List<ColumnInfo> getColumnInfoList() {
        return this.columnInfoList;
    }

    public Map<String, Object> getColumnTypeMap() {
        return this.columnTypeMap;
    }

    public Map<String, MapObject> getColumnIndexMapping() {
        return this.columnIndexMapping;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getSchemaTable() {
        return this.schemaTable;
    }

    public ServerMode getServer() {
        return this.server;
    }

    public boolean isIgnoreUnhex() {
        return this.ignoreUnhex;
    }

    public void setIgnoreUnhex(boolean ignoreUnhex) {
        this.ignoreUnhex = ignoreUnhex;
    }

    public boolean isLogicalDatabase() {
        return this.logicalDatabase;
    }

    public void setLogicalDatabase(boolean logicalDatabase) {
        this.logicalDatabase = logicalDatabase;
    }

    public boolean isEmptyTable() {
        return this.emptyTable;
    }

    public void setEmptyTable(boolean emptyTable) {
        this.emptyTable = emptyTable;
    }

    public boolean isWithDatafiles() {
        return this.withDatafiles;
    }

    public void setWithDatafiles(boolean withDatafiles) {
        this.withDatafiles = withDatafiles;
    }

    public boolean isDumpOperation() {
        return this.dumpOperation;
    }

    public boolean isHiddenPrimaryKeyEnabled() {
        return this.hiddenPrimaryKeyEnabled;
    }

    public void setHiddenPrimaryKeyEnabled(boolean hiddenPrimaryKeyEnabled) {
        this.hiddenPrimaryKeyEnabled = hiddenPrimaryKeyEnabled;
    }

    public boolean isExcludeVirtualColumns() {
        return this.excludeVirtualColumns;
    }

    public void setExcludeVirtualColumns(boolean excludeVirtualColumns) {
        this.excludeVirtualColumns = excludeVirtualColumns;
    }

    public String[] getCsvHeaders() {
        return this.csvHeaders;
    }

    public StringBuilder getInsertPrefix() {
        return this.insertPrefix;
    }

    public StringBuilder getReplacePrefix() {
        return this.replacePrefix;
    }

    public String getSelectColumns() {
        return this.selectColumns;
    }

    public String getInsertColumns() {
        return this.insertColumns;
    }

    public Map<Integer, String> getRowKeyMap() {
        return this.rowKeyMap;
    }

    public void setRowKeyMap(Map<Integer, String> rowKeyMap) {
        this.rowKeyMap = rowKeyMap;
    }

    public List<String> getPrimaryCols() {
        return this.primaryCols;
    }

    public void setPrimaryCols(List<String> primaryCols) {
        this.primaryCols = primaryCols;
    }

    public Map<String, List<String>> getUniqueKeyMap() {
        return this.uniqueKeyMap;
    }

    public void setUniqueKeyMap(Map<String, List<String>> uniqueKeyMap) {
        this.uniqueKeyMap = uniqueKeyMap;
    }

    public Map<String, List<String>> getNotNullUniqueKeyMap() {
        return this.notNullUniqueKeyMap;
    }

    public void setNotNullUniqueKeyMap(Map<String, List<String>> notNullUniqueKeyMap) {
        this.notNullUniqueKeyMap = notNullUniqueKeyMap;
    }
}

