/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.compress;

import com.oceanbase.tools.loaddump.compress.CompressAlgo;
import com.oceanbase.tools.loaddump.compress.Compressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class ZlibCompressor
implements Compressor {
    private int level = -1;

    public ZlibCompressor() {
    }

    public ZlibCompressor(int level) {
        this.level = level;
    }

    @Override
    public OutputStream compress(OutputStream outputStream) throws IOException {
        return new DeflaterOutputStream(outputStream, new Deflater(this.level));
    }

    @Override
    public InputStream decompress(InputStream inputStream) throws IOException {
        return new InflaterInputStream(inputStream, new Inflater());
    }

    @Override
    public CompressAlgo getCompressAlgo() {
        return CompressAlgo.ZLIB;
    }

    @Override
    public int getCompressLevel() {
        return this.level;
    }

    @Override
    public String getCompressSuffix() {
        return CompressAlgo.ZLIB.getSuffix();
    }
}

