/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.compress;

import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import com.oceanbase.tools.loaddump.compress.CompressAlgo;
import com.oceanbase.tools.loaddump.compress.Compressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZstdCompressor
implements Compressor {
    private int level = 3;

    public ZstdCompressor() {
    }

    public ZstdCompressor(int level) {
        this.level = level;
    }

    @Override
    public OutputStream compress(OutputStream outputStream) throws IOException {
        return new ZstdOutputStreamNoFinalizer(outputStream).setLevel(this.level).setChecksum(false).setCloseFrameOnFlush(false);
    }

    @Override
    public InputStream decompress(InputStream inputStream) throws IOException {
        return new ZstdInputStreamNoFinalizer(inputStream);
    }

    @Override
    public CompressAlgo getCompressAlgo() {
        return CompressAlgo.ZSTD;
    }

    @Override
    public int getCompressLevel() {
        return this.level;
    }

    @Override
    public String getCompressSuffix() {
        return CompressAlgo.ZSTD.getSuffix();
    }
}

