/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.concurrent;

import com.oceanbase.tools.loaddump.concurrent.FlowLimiter;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemaphoreLimiter
implements FlowLimiter {
    private static final Logger log = LoggerFactory.getLogger(SemaphoreLimiter.class);
    private final int threshold;
    private final Semaphore semaphore;

    public SemaphoreLimiter(int threshold) {
        this.threshold = threshold;
        this.semaphore = new Semaphore(threshold, false);
    }

    public void acquire(int permits) throws ResourceInsufficientException, InterruptedException {
        this.checkResource(permits);
        this.semaphore.acquire(permits);
    }

    public void acquireUninterruptibly(int permits) throws ResourceInsufficientException {
        this.checkResource(permits);
        this.semaphore.acquireUninterruptibly(permits);
    }

    @Override
    public boolean tryAcquire(int permits) throws ResourceInsufficientException {
        this.checkResource(permits);
        return this.semaphore.tryAcquire(permits);
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws ResourceInsufficientException, InterruptedException {
        this.checkResource(permits);
        return this.semaphore.tryAcquire(permits, timeout, unit);
    }

    @Override
    public void release(int permits) {
        try {
            this.semaphore.release(Math.min(permits, this.semaphore.availablePermits()));
        }
        catch (Throwable th) {
            log.debug("......Ignore to free {} heap memory failed", (Object)permits);
        }
    }

    @Override
    public int getPermits() {
        return this.threshold;
    }

    private void checkResource(int permits) throws ResourceInsufficientException {
        if (permits > this.threshold) {
            throw new ResourceInsufficientException("HeapMemory is not enough. (Alloc: " + FileUtils.byteCountToDisplaySize((long)permits) + " > Limit: " + FileUtils.byteCountToDisplaySize((long)this.threshold) + "). Please reduce --batch or set -Xms/-Xmx.");
        }
    }

    public static class ResourceInsufficientException
    extends Exception {
        private static final long serialVersionUID = 5016236780709694571L;

        public ResourceInsufficientException(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }
}

