/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.concurrent;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.StopStrategy;
import com.oceanbase.tools.loaddump.common.exception.NonRetryableException;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;

public class SmartStopStrategy
implements StopStrategy {
    private final AtomicBoolean supervisor;
    private final int maxAttempts;
    private final Class<?> stopExceptionClass;

    public SmartStopStrategy(@NonNull AtomicBoolean supervisor, int maxAttempts) {
        this(supervisor, maxAttempts, NonRetryableException.class);
        if (supervisor == null) {
            throw new NullPointerException("supervisor is marked non-null but is null");
        }
    }

    public SmartStopStrategy(@NonNull AtomicBoolean supervisor, int maxAttempts, Class<?> stopExceptionClass) {
        if (supervisor == null) {
            throw new NullPointerException("supervisor is marked non-null but is null");
        }
        this.supervisor = supervisor;
        this.maxAttempts = maxAttempts;
        this.stopExceptionClass = stopExceptionClass;
    }

    public boolean shouldStop(Attempt failedAttempt) {
        if (!this.supervisor.get()) {
            return true;
        }
        if (this.maxAttempts < 1) {
            return true;
        }
        if (this.stopExceptionClass.isAssignableFrom(failedAttempt.getExceptionCause().getClass())) {
            return true;
        }
        return failedAttempt.getAttemptNumber() > (long)this.maxAttempts;
    }
}

