/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.context;

import java.util.List;
import lombok.NonNull;

public class SqlContext {
    private String sql;
    private int count;
    private boolean completed;
    private List<List<Object>> batchArgs;

    public SqlContext(@NonNull String sql, int count, List<List<Object>> batchArgs) {
        this(sql, count, batchArgs, true);
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
    }

    public SqlContext(@NonNull String sql, int count, List<List<Object>> batchArgs, boolean completed) {
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        this.sql = sql;
        this.count = count;
        this.batchArgs = batchArgs;
        this.completed = completed;
    }

    public void clearAll() {
        this.sql = null;
        this.count = 0;
        this.completed = true;
        if (this.batchArgs != null) {
            for (List<Object> args : this.batchArgs) {
                args.clear();
                Object var2_2 = null;
            }
            this.batchArgs.clear();
            this.batchArgs = null;
        }
    }

    public String getSql() {
        return this.sql;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public List<List<Object>> getBatchArgs() {
        return this.batchArgs;
    }
}

