/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.divider;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.divider.AbstractFileDivider;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvRecordParser;
import com.oceanbase.tools.loaddump.resource.ResourceV2;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvFileDivider
extends AbstractFileDivider {
    private static final Logger log = LoggerFactory.getLogger(CsvFileDivider.class);
    private static final char DISABLED = '\ufffe';
    private final CsvFormat csvFormat;

    public CsvFileDivider(ResourceV2 resource, long blockSize, CsvFormat csvFormat) {
        super(resource, blockSize, CsvFileDivider.mapNullToDisabled(csvFormat.getEscapeCharacter()), CsvFileDivider.mapNullToDisabled(csvFormat.getQuoteCharacter()));
        this.csvFormat = csvFormat;
    }

    @Override
    public List<SubFile> divideFile() throws Exception {
        long end;
        long start;
        Throwable throwable;
        Stopwatch stopwatch = Stopwatch.createStarted();
        String table = this.resource.getObjectName();
        String path = this.resource.getPath();
        Preconditions.checkArgument((this.csvFormat != null ? 1 : 0) != 0, (String)"CsvFormat is null. Table: %s", (Object)table);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(table), (Object)"Input table is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(path), (String)"Input file path is null. Table: %s", (Object)table);
        Preconditions.checkArgument((this.blockSize >= 1L ? 1 : 0) != 0, (String)"Invalid block size: %s. Table: %s", (long)this.blockSize, (Object)table);
        if (!this.csvFormat.getSkipHeaderRecord() && ArrayUtils.isEmpty((Object[])this.csvFormat.getHeader())) {
            throw new IllegalArgumentException("The header of CSVFormat is null");
        }
        ArrayList<String> headers = new ArrayList<String>();
        if (this.csvFormat.getSkipHeaderRecord()) {
            throwable = null;
            try (CsvRecordParser parser = this.csvFormat.parse(new FileReader(path));){
                headers.addAll(parser.getHeaderNames());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        } else {
            headers.addAll(Lists.newArrayList((Object[])Objects.requireNonNull(this.csvFormat.getHeader())));
        }
        throwable = null;
        try (RandomAccessFile raf = new RandomAccessFile(new File(path), "r");){
            long length = raf.length();
            if (length <= this.blockSize) {
                SubFile subFile = new SubFile(this.resource, 0, 0L, length, DataFormat.CSV);
                subFile.setHeaders(headers);
                if (log.isDebugEnabled()) {
                    log.debug("File: \"{}\" has not been split. {} < {}", new Object[]{path, length, this.blockSize});
                }
                ArrayList arrayList = Lists.newArrayList((Object[])new SubFile[]{subFile});
                return arrayList;
            }
        }
        catch (Throwable length) {
            throwable = length;
            throw length;
        }
        long[] realPos = super.divideInternal();
        ArrayList<SubFile> subFiles = new ArrayList<SubFile>();
        for (int i = 1; i <= this.chunkNum && (start = realPos[i - 1]) != (end = realPos[i]); ++i) {
            SubFile subFile = new SubFile(this.resource, i, start, end, DataFormat.CSV);
            subFile.setHeaders(headers);
            subFiles.add(subFile);
        }
        log.info("File: \"{}\" has been split into {} chunks. Elapsed: {}", new Object[]{path, subFiles.size(), stopwatch});
        return subFiles;
    }

    private static char mapNullToDisabled(Character c) {
        return c == null ? (char)'\ufffe' : (char)c.charValue();
    }
}

