/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.divider;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.divider.AbstractFileDivider;
import com.oceanbase.tools.loaddump.resource.ResourceV2;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFileDivider
extends AbstractFileDivider {
    private static final Logger log = LoggerFactory.getLogger(SqlFileDivider.class);

    public SqlFileDivider(ResourceV2 resource, long blockSize) {
        super(resource, blockSize);
    }

    @Override
    public List<SubFile> divideFile() throws Exception {
        long end;
        long start;
        Stopwatch stopwatch = Stopwatch.createStarted();
        String table = this.resource.getObjectName();
        String path = this.resource.getPath();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(table), (Object)"Input table is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(path), (Object)("Input file path is null. Table: %s" + table));
        Preconditions.checkArgument((this.blockSize >= 1L ? 1 : 0) != 0, (String)"Invalid block size: %s. Table: %s", (long)this.blockSize, (Object)table);
        try (RandomAccessFile raf = new RandomAccessFile(new File(path), "r");){
            long length = raf.length();
            if (length <= this.blockSize) {
                ArrayList arrayList = Lists.newArrayList((Object[])new SubFile[]{new SubFile(this.resource, 0, 0L, length, DataFormat.SQL)});
                return arrayList;
            }
        }
        long[] realPos = super.divideInternal();
        ArrayList<SubFile> subFiles = new ArrayList<SubFile>();
        for (int i = 1; i <= this.chunkNum && (start = realPos[i - 1]) != (end = realPos[i]); ++i) {
            subFiles.add(new SubFile(this.resource, i, start, end, DataFormat.SQL));
        }
        log.info("File: \"{}\" has been splitted into {} copies. Elapsed: {}", new Object[]{path, subFiles.size(), stopwatch});
        return subFiles;
    }
}

