/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.schema;

import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.concurrent.ThreadPoolBuilder;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.dumper.AbstractDumper;
import com.oceanbase.tools.loaddump.dumper.task.schema.AbstractSchemaDumpTask;
import com.oceanbase.tools.loaddump.generator.SchemaDumpTaskGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFileDumper
extends AbstractDumper<AbstractSchemaDumpTask> {
    private static final Logger log = LoggerFactory.getLogger(SchemaFileDumper.class);

    public SchemaFileDumper(DumpParameter parameter) {
        super(parameter);
        this.taskGenerator = this.createDumpTaskGenerator();
    }

    public SchemaDumpTaskGenerator createDumpTaskGenerator() {
        return new SchemaDumpTaskGenerator(this.parameter);
    }

    @Override
    public TaskContext dumpRecordAsync() throws Exception {
        throw new UnsupportedOperationException("not implement");
    }

    @Override
    public TaskContext dumpSchemaAsync() throws Exception {
        super.checkState();
        int corePoolSize = this.parameter.getThreads();
        this.defaultExecutor = new ThreadPoolBuilder().setCorePoolSize(corePoolSize).setMaximumPoolSize(corePoolSize).setQueueSize(this.dumpTasks.size()).setThreadPrefixName("dump-schema-thread-").build();
        this.dumpTasks.forEach(t -> this.defaultExecutor.submit((Runnable)t));
        log.info("Start {} schema dump threads for {} dump tasks finished.", (Object)corePoolSize, (Object)this.dumpTasks.size());
        this.state = State.RUNNING;
        return this;
    }
}

