/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.record;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.model.ColumnInfo;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.RangeKey;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TableRangeInfo;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.dumper.assembler.AbstractStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.task.AbstractDumpTask;
import com.oceanbase.tools.loaddump.dumper.translator.AbstractRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.ColRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.CsvRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.CutRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.PosRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.SqlRecordTranslator;
import com.oceanbase.tools.loaddump.function.AbstractUserDefinedFunction;
import com.oceanbase.tools.loaddump.function.SqlFunction;
import com.oceanbase.tools.loaddump.function.context.ControlDescription;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvPrinter;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.vmoption.JavaOpts;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import com.oceanbase.tools.loaddump.writer.file.CsvWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordDumpTask
extends AbstractDumpTask {
    private static final Logger log = LoggerFactory.getLogger(RecordDumpTask.class);
    private static final long serialVersionUID = 2223238398433917159L;
    protected int commitSize;
    protected long maxFileSize;
    protected int fetchSize;
    protected boolean emptyTable;
    protected boolean customQuery;
    protected Long maxRows;
    protected boolean retainEmptyFile;
    protected String fileSuffix;
    protected TableRangeInfo tableRangeInfo;
    protected boolean preserveZeroDatetime;
    protected transient Meter meter;
    protected transient CsvFormat csvFormat;
    protected transient AbstractStatementAssembler assembler;
    protected transient AbstractRollingFileWriterV2 fileWriter;
    protected transient AbstractRecordTranslator recordTranslator;
    private transient AtomicLong fileSizeAccumulator;

    public RecordDumpTask() {
    }

    public RecordDumpTask(String tableName, AbstractStatementAssembler assembler) {
        this(tableName, assembler, false);
    }

    public RecordDumpTask(boolean emptyTable, String tableName, AbstractStatementAssembler assembler) {
        this(tableName, assembler);
        this.emptyTable = emptyTable;
    }

    public RecordDumpTask(String tableName, AbstractStatementAssembler assembler, boolean emptyTable) {
        this.emptyTable = emptyTable;
        this.assembler = assembler;
        this.maxFileSize = assembler.getParameter().getMaxFileSize();
        this.tableRangeInfo = assembler.getTableRangeInfo();
        this.schemaName = assembler.getParameter().getDatabaseName();
        this.objectName = tableName;
    }

    @Override
    public void initialize(DumpParameter parameter) throws Exception {
        super.initialize(parameter);
        this.commitSize = parameter.getCommitSize();
        this.fetchSize = parameter.getFetchSize();
        this.checkpointPath = parameter.getCheckpointPath();
        this.recordTranslator = this.createRecordTranslator(parameter);
        if (parameter.isRetry()) {
            this.assembler.setParameter(parameter);
        }
        this.customQuery = StringUtils.isNotBlank(parameter.getQuerySql());
        this.maxRows = parameter.getMaxRows();
        this.fileSuffix = parameter.getFileSuffix();
        this.retainEmptyFile = parameter.isRetainEmptyFiles();
        this.preserveZeroDatetime = parameter.isPreserveZeroDatetime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.updateTaskState(TaskState.RUNNING);
            if (!this.emptyTable) {
                try (Connection conn = this.sessionManager.createNewConnection();){
                    if (this.maxFileSize > 0L) {
                        this.executeSync(conn, this.assembler.assembleQuerySql());
                    } else {
                        this.executeUnsync(conn, this.assembler.assembleQuerySql());
                    }
                }
            }
            this.fileWriter.markDone();
            this.updateTaskState(TaskState.SUCCESS);
        }
        catch (Throwable e) {
            this.message = ExceptionUtils.getRootCauseMessage(e);
            log.error("Dump {} failed. ", (Object)this.getTablePartition(), (Object)e);
            this.updateTaskState(TaskState.FAILURE);
        }
        finally {
            this.updateTaskDetail();
            super.updateCheckpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSync(Connection conn, List<String> querySqlList) throws Exception {
        AtomicLong atomicLong = this.fileSizeAccumulator;
        synchronized (atomicLong) {
            if (this.maxFileSize > 0L && this.fileSizeAccumulator.get() >= this.maxFileSize) {
                return;
            }
            this.executeUnsync(conn, querySqlList);
        }
    }

    protected void executeUnsync(Connection conn, List<String> querySqlList) throws Exception {
        boolean hasValues = !this.customQuery && this.tableRangeInfo.hasPrimary();
        block32: for (int i = 0; this.supervisor.get() && i < querySqlList.size(); ++i) {
            long begin = 0L;
            if (JavaOpts.isDebugable) {
                begin = System.currentTimeMillis();
            }
            String querySql = querySqlList.get(i);
            RangeKey[] primaryValues = this.tableRangeInfo.getPrimaryValues(i);
            try (PreparedStatement ps = conn.prepareStatement(querySql, 1003, 1007);){
                ps.setFetchSize(this.fetchSize);
                for (int idx = 0; idx < primaryValues.length; ++idx) {
                    ps.setObject(idx + 1, primaryValues[idx].getValue());
                }
                try (ResultSet rs = ps.executeQuery();){
                    if (JavaOpts.isDebugable) {
                        String range = Arrays.stream(primaryValues).map(RangeKey::getValue).collect(Collectors.joining(","));
                        log.info("Query SQL: {}. Range: [{}]. Elapsed: {}ms", new Object[]{querySql, range, System.currentTimeMillis() - begin});
                    }
                    boolean isInitiated = true;
                    while (this.supervisor.get() && rs.next()) {
                        if (isInitiated) {
                            this.reassignParams(rs);
                            isInitiated = false;
                        }
                        Object record = this.recordTranslator.translate(rs, this.customQuery);
                        if (JavaOpts.isDryRunMode) {
                            this.meter.mark(1L, record.toString().getBytes().length, 1L);
                            continue;
                        }
                        long size = this.fileWriter.write(record);
                        this.meter.mark(1L, size, 1L);
                        ++this.recordCount;
                        if (this.recordCount > 0L && this.maxFileSize > 0L && this.fileSizeAccumulator.addAndGet(size) >= this.maxFileSize) {
                            log.warn("Stop dump: {} Size: {} >= {}", new Object[]{this.getTablePartition(), this.fileSizeAccumulator.get(), this.maxFileSize});
                            break block32;
                        }
                        if (!this.customQuery || this.maxRows == null || this.maxRows == 0L || this.recordCount != this.maxRows) continue;
                        log.warn("Reach max row limit (<={}).", (Object)this.maxRows);
                        break block32;
                    }
                    continue;
                }
            }
            catch (Exception e) {
                String range = hasValues ? Arrays.stream(primaryValues).map(RangeKey::getValue).collect(Collectors.joining(",")) : "[--]";
                log.error("Dump failed. Reason: {}. SQL: {}. Range: {}.", new Object[]{ExceptionUtils.getRootCauseMessage(e), querySql, range});
                if (JavaOpts.isDebugable) {
                    e.printStackTrace();
                }
                throw new IllegalStateException(e);
            }
        }
    }

    private AbstractRecordTranslator createRecordTranslator(DumpParameter parameter) {
        AbstractRecordTranslator recordTranslator;
        TableInfo tableInfo = parameter.getDatabase().getTableInfo(this.objectName);
        ControlManager controlManager = parameter.getControlManager();
        if (DataFormat.SQL == parameter.getDataFormat()) {
            recordTranslator = new SqlRecordTranslator(tableInfo, controlManager);
        } else if (DataFormat.CSV == parameter.getDataFormat()) {
            recordTranslator = new CsvRecordTranslator(tableInfo, controlManager, this.csvFormat);
        } else if (DataFormat.CUT == parameter.getDataFormat()) {
            recordTranslator = new CutRecordTranslator(tableInfo, controlManager, this.csvFormat, parameter.getColumnSplitter(), parameter.isRemoveNewline());
        } else if (parameter.getDataFormat().isBinary()) {
            recordTranslator = new ColRecordTranslator(tableInfo, controlManager);
        } else if (DataFormat.POS == parameter.getDataFormat()) {
            Preconditions.checkArgument((boolean)controlManager.isControlDefined(this.schemaName, tableInfo.getTable()), (Object)("Exporting file of fixed-length format requires a control file for the corresponding table: " + tableInfo.getTable()));
            recordTranslator = new PosRecordTranslator(tableInfo, controlManager, this.csvFormat.getRecordSeparator(), parameter.getFileEncoding(), parameter.isRemoveNewline());
        } else {
            throw new UnsupportedOperationException("Unsupported data format: " + (Object)((Object)parameter.getDataFormat()));
        }
        recordTranslator.setUseRuntimeTableName(parameter.isUseRuntimeTableName());
        return recordTranslator;
    }

    private void reassignParams(ResultSet rs) throws Exception {
        ControlManager controlManager;
        this.recordTranslator.init(rs, this.customQuery);
        if (this.fileWriter instanceof CsvWriter) {
            this.assignCsvHeader(rs);
        }
        if (!this.customQuery) {
            return;
        }
        boolean useRuntimeName = this.recordTranslator.isUseRuntimeTableName();
        TableInfo tableInfo = this.recordTranslator.getTableInfo();
        tableInfo.resetTableInfo(rs, this.serverMode, useRuntimeName, this.preserveZeroDatetime);
        if (this.recordTranslator instanceof SqlRecordTranslator) {
            ((SqlRecordTranslator)this.recordTranslator).setInsertPrefix(tableInfo.getInsertPrefix().toString() + " VALUES (");
        }
        if (Objects.isNull(controlManager = this.recordTranslator.getControlManager())) {
            return;
        }
        String schemaName = tableInfo.getSchema();
        String tableName = tableInfo.getTable();
        for (ColumnInfo columnInfo : tableInfo.getColumnInfoList()) {
            List<SqlFunction> callStacks;
            ControlDescription control;
            String columnName = columnInfo.getColumnName();
            if (useRuntimeName) {
                schemaName = columnInfo.getSchemaName();
                tableName = columnInfo.getTableName();
            }
            if (Objects.isNull(control = controlManager.getControl(schemaName, tableName, columnName)) || CollectionUtils.isEmpty(callStacks = control.getCallStacks())) continue;
            for (SqlFunction sqlFunction : callStacks) {
                if (!(sqlFunction instanceof AbstractUserDefinedFunction)) continue;
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("column_name", columnName);
                paramMap.put("table_name", tableName);
                paramMap.put("data_type", tableInfo.getColumnType(columnName));
                ((AbstractUserDefinedFunction)sqlFunction).setParams(paramMap);
            }
        }
    }

    public void expireCache() {
        if (this.assembler != null) {
            this.assembler.expireCache();
        }
    }

    @Override
    protected void updateTaskDetail() {
        this.taskDetail.setSchema(this.schemaName);
        this.taskDetail.setObject(this.objectName);
        this.taskDetail.setType(ObjectType.TABLE.getName());
        this.taskDetail.setCount(this.recordCount);
        this.taskDetail.setState(this.taskState);
        this.taskDetail.setError(this.message);
        this.taskDetail.setTaskType(TaskType.DUMP_RECORD);
    }

    private void assignCsvHeader(ResultSet rs) throws Exception {
        if (this.csvFormat.getSkipHeaderRecord()) {
            return;
        }
        if (this.customQuery) {
            this.csvFormat = this.csvFormat.withHeader(rs);
        }
        StringBuilder headerBuilder = new StringBuilder(48);
        try (CsvPrinter ignored = new CsvPrinter(headerBuilder, this.csvFormat);){
            ((CsvWriter)((Object)this.fileWriter)).setCsvHeader(headerBuilder.toString());
        }
    }

    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    public void setCsvFormat(CsvFormat csvFormat) {
        this.csvFormat = csvFormat;
    }

    public void setFileWriter(AbstractRollingFileWriterV2 fileWriter) {
        this.fileWriter = fileWriter;
    }

    public void setFileSizeAccumulator(AtomicLong fileSizeAccumulator) {
        this.fileSizeAccumulator = fileSizeAccumulator;
    }
}

