/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.translator;

import com.google.common.base.Strings;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.dumper.translator.AbstractRecordTranslator;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class PosRecordTranslator
extends AbstractRecordTranslator<StringBuilder> {
    private final List<Offset> offsets;
    private final String lineSep;
    private final Charset charset;
    private final boolean removeNewline;

    public PosRecordTranslator(TableInfo tableInfo, ControlManager ctrlManager, String lineSep, String charset, boolean removeNewline) {
        super(tableInfo, ctrlManager);
        this.offsets = this.controlManager.getOffsets(tableInfo.getSchema(), tableInfo.getTable());
        this.lineSep = lineSep;
        this.charset = Charset.forName(charset);
        this.removeNewline = removeNewline;
    }

    @Override
    protected StringBuilder buildRecordPattern(int columnCount) {
        return new StringBuilder(4096);
    }

    @Override
    protected StringBuilder formatRecord(StringBuilder recordPattern, String columnValue, int index, boolean hasNext) {
        int len = this.offsets.get(index).getLength();
        return recordPattern.append(this.formatFixedLengthString(columnValue, len));
    }

    @Override
    protected StringBuilder appendLineSeparator(StringBuilder record) {
        return record.append(this.lineSep);
    }

    private String formatFixedLengthString(String input, int limits) {
        byte[] inputBytes;
        if (input == null) {
            byte[] bytes = new byte[limits];
            Arrays.fill(bytes, (byte)32);
            return new String(bytes, this.charset);
        }
        if (this.removeNewline) {
            input = input.replaceAll("[\r\n]", "");
        }
        if ((inputBytes = input.getBytes(this.charset)).length > limits) {
            int charPos = 0;
            int totalCharBytes = 0;
            char[] chars = input.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isSurrogate(chars[i])) {
                    if (!Character.isHighSurrogate(chars[i]) || i + 1 >= chars.length || !Character.isLowSurrogate(chars[i + 1])) continue;
                    char[] temp = new char[]{chars[i], chars[i + 1]};
                    int emojiBytes = new String(temp).getBytes(this.charset).length;
                    int tempCurrBytes = totalCharBytes + emojiBytes;
                    if (tempCurrBytes > limits) break;
                    charPos += 2;
                    totalCharBytes = tempCurrBytes;
                    continue;
                }
                int charBytes = String.valueOf(chars[i]).getBytes(this.charset).length;
                int tempCurrBytes = totalCharBytes + charBytes;
                if (tempCurrBytes > limits) break;
                ++charPos;
                totalCharBytes = tempCurrBytes;
            }
            String value = input.substring(0, charPos);
            return totalCharBytes < limits ? value + Strings.repeat((String)" ", (int)(limits - totalCharBytes)) : value;
        }
        byte[] resultBytes = new byte[limits];
        System.arraycopy(inputBytes, 0, resultBytes, 0, inputBytes.length);
        for (int i = inputBytes.length; i < limits; ++i) {
            resultBytes[i] = 32;
        }
        return new String(resultBytes, this.charset);
    }
}

