/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.translator;

import com.oceanbase.tools.loaddump.common.constants.JdbcType;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.dumper.translator.AbstractRecordTranslator;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import java.util.HashMap;
import java.util.Map;

public class SqlRecordTranslator
extends AbstractRecordTranslator<StringBuilder> {
    private String insertPrefix;
    private static final Map<String, TimeFunctionFormat> functionMap = new HashMap<String, TimeFunctionFormat>();

    public SqlRecordTranslator(TableInfo tableInfo, ControlManager controlManager) {
        super(tableInfo, controlManager);
        if (tableInfo.getInsertPrefix() != null) {
            this.insertPrefix = tableInfo.getInsertPrefix() + " VALUES (";
        }
    }

    @Override
    protected StringBuilder buildRecordPattern(int columnCount) {
        return new StringBuilder(4096).append(this.insertPrefix);
    }

    @Override
    protected StringBuilder formatRecord(StringBuilder recordPattern, String columnValue, int logicPosition, boolean hasNext) {
        if (columnValue == null) {
            recordPattern.append("null");
            if (hasNext) {
                recordPattern.append(',');
            }
            return recordPattern;
        }
        boolean needAppendParentheses = true;
        boolean isMysqlMode = this.tableInfo.isMySqlMode();
        String columnType = this.tableInfo.getColumnTypeName(logicPosition);
        TimeFunctionFormat tff = functionMap.get(columnType);
        if (isMysqlMode) {
            if (JdbcType.isBinaryType(columnType)) {
                recordPattern.append("unhex(");
            } else {
                needAppendParentheses = false;
            }
        } else if (JdbcType.isBinaryType(columnType)) {
            recordPattern.append("HEXTORAW(");
        } else if (tff != null) {
            recordPattern.append(tff.function);
        } else {
            needAppendParentheses = false;
        }
        boolean isNeedEscape = this.tableInfo.isNeedEscape(logicPosition);
        if (isNeedEscape) {
            columnValue = this.escapeString(columnValue, this.tableInfo.isMySqlMode());
        }
        if (isNeedEscape || this.tableInfo.isNeedQuote(logicPosition)) {
            if (JdbcType.isGeometryType(columnType)) {
                recordPattern.append(columnValue);
            } else {
                recordPattern.append("'").append(columnValue).append("'");
            }
            if (!isMysqlMode && tff != null) {
                recordPattern.append(",").append("'").append(tff.format).append("'");
            }
        } else {
            recordPattern.append(columnValue);
        }
        if (needAppendParentheses) {
            recordPattern.append(")");
        }
        if (hasNext) {
            recordPattern.append(',');
        }
        return recordPattern;
    }

    @Override
    protected StringBuilder appendLineSeparator(StringBuilder record) {
        return record.append(");").append(System.lineSeparator());
    }

    public StringBuilder appendCommitPoint(StringBuilder record) {
        return record.append("commit;").append(System.lineSeparator());
    }

    public String escapeString(String columnValue, boolean isMySqlMode) {
        int length = columnValue.length();
        StringBuilder sb = new StringBuilder(length);
        block10: for (int i = 0; i < length; ++i) {
            char c = columnValue.charAt(i);
            if (isMySqlMode) {
                switch (c) {
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\'': {
                        sb.append("''");
                        break;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    sb.append("''");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void setInsertPrefix(String insertPrefix) {
        this.insertPrefix = insertPrefix;
    }

    static {
        functionMap.put("date", TimeFunctionFormat.DATE);
        functionMap.put("timestamp", TimeFunctionFormat.TIMESTAMP);
        functionMap.put("timestamp with time zone", TimeFunctionFormat.TIMESTAMPTZ);
        functionMap.put("timestamp with local time zone", TimeFunctionFormat.TIMESTAMPLTZ);
    }

    private static enum TimeFunctionFormat {
        DATE("to_date(", "YYYY-MM-DD HH24:MI:SS"),
        TIMESTAMP("to_timestamp(", "YYYY-MM-DD HH24:MI:SS:FF9"),
        TIMESTAMPTZ("to_timestamp_tz(", "YYYY-MM-DD HH24:MI:SS:FF TZR TZD"),
        TIMESTAMPLTZ("to_timestamp_tz(", "YYYY-MM-DD HH24:MI:SS:FF TZR TZD");

        private final String function;
        private final String format;

        private TimeFunctionFormat(String function, String format) {
            this.function = function;
            this.format = format;
        }
    }
}

