/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.context;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.function.context.ControlDescription;
import com.oceanbase.tools.loaddump.function.enums.Languages;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public class ControlContext {
    private final Map<Integer, ControlDescription> controlDescriptionMap = new LinkedHashMap<Integer, ControlDescription>();
    private final Map<String, ControlDescription> columnNameDescriptionMap = new LinkedHashMap<String, ControlDescription>();
    private Languages languages;
    private String schemaName;
    private String tableName;
    private boolean isOracle;
    private List<Offset> offsets;

    public void add(@NonNull ControlDescription columnDescription) {
        if (columnDescription == null) {
            throw new NullPointerException("columnDescription is marked non-null but is null");
        }
        String columnName = columnDescription.getColumnName();
        if (!columnName.equalsIgnoreCase("_FILLER")) {
            Collection<ControlDescription> originals = this.controlDescriptionMap.values();
            for (ControlDescription original : originals) {
                Preconditions.checkArgument((!columnName.equals(original.getColumnName()) ? 1 : 0) != 0, (String)"The column \"%s\" has already defined", (Object)columnName);
            }
        }
        this.controlDescriptionMap.put(columnDescription.getColumnId(), columnDescription);
        this.columnNameDescriptionMap.put(columnName, columnDescription);
    }

    public ControlDescription getControlDescription(int columnId) {
        return this.controlDescriptionMap.get(columnId);
    }

    public ControlDescription getControlDescriptionByColumnName(String columnName) {
        return this.columnNameDescriptionMap.getOrDefault(columnName, null);
    }

    public String invokeControl(int columnId) {
        return this.invokeControl(columnId, null);
    }

    public String invokeControl(int columnId, String value) {
        return this.getControlDescription(columnId).invoke(value);
    }

    public int getColumnSize() {
        return this.controlDescriptionMap.size();
    }

    public List<Integer> getColumnIdList() {
        return new ArrayList<Integer>(this.controlDescriptionMap.keySet());
    }

    public List<String> getColumnNameList() {
        return new ArrayList<String>(this.columnNameDescriptionMap.keySet());
    }

    public List<Offset> getOffsets() {
        if (this.offsets != null) {
            return this.offsets;
        }
        this.offsets = Collections.unmodifiableList(this.controlDescriptionMap.values().stream().map(ControlDescription::getOffset).collect(Collectors.toList()));
        return this.offsets;
    }

    public String toString() {
        return this.controlDescriptionMap.values().stream().map(ControlDescription::toString).collect(Collectors.joining("\n"));
    }

    public Languages getLanguages() {
        return this.languages;
    }

    public void setLanguages(Languages languages) {
        this.languages = languages;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public void setOracle(boolean isOracle) {
        this.isOracle = isOracle;
    }
}

