/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.crypto;

import com.oceanbase.tools.loaddump.function.crypto.AbstractDigestFunction;
import com.oceanbase.tools.loaddump.function.crypto.TextEncoding;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.utils.SecurityUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Base64;
import org.apache.commons.codec.binary.Hex;

public class SM3DigestFunction
extends AbstractDigestFunction {
    public SM3DigestFunction() {
    }

    public SM3DigestFunction(String encoding) {
        super(encoding);
    }

    @Override
    public String getName() {
        return SqlFunctions.SM3_DIGEST.name();
    }

    @Override
    public String invoke(String ... varargs) {
        String val = varargs[0];
        if (StringUtils.isEmpty(val)) {
            return val;
        }
        try {
            byte[] res = SecurityUtils.hashSM3(val.getBytes());
            if (this.encoding == TextEncoding.BASE64) {
                return Base64.getEncoder().encodeToString(res);
            }
            return Hex.encodeHexString((byte[])res);
        }
        catch (Exception e) {
            throw new RuntimeException("SM3 digest failed.", e);
        }
    }
}

