/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.date;

import com.oceanbase.tools.loaddump.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class TimestampFormatFunction
extends AbstractBuiltinFunction {
    private final String originPattern;
    private final String replacementTms;
    private final String targetPattern;

    public TimestampFormatFunction(String originPattern, String replacementTms) {
        this(originPattern, replacementTms, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public TimestampFormatFunction(String originPattern, String replacementTms, String targetPattern) {
        this.originPattern = originPattern;
        this.replacementTms = replacementTms;
        this.targetPattern = targetPattern;
    }

    @Override
    public String getName() {
        return SqlFunctions.TMSFMT.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return this.formatTimestamp(varargs == null ? null : varargs[0]);
    }

    private String formatTimestamp(String value) {
        if (value == null) {
            return null;
        }
        try {
            String[] parsePatterns = new String[]{this.originPattern};
            Date date = DateUtils.parseDate((String)value.trim(), (String[])parsePatterns);
            return new SimpleDateFormat(this.targetPattern).format(date);
        }
        catch (ParseException e) {
            return this.getReplacementTms();
        }
    }

    public String getOriginPattern() {
        return this.originPattern;
    }

    public String getReplacementTms() {
        return this.replacementTms;
    }

    public String getTargetPattern() {
        return this.targetPattern;
    }
}

