/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.date;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.WeekFields;

public class WeekFunction
extends AbstractBuiltinFunction {
    private final DateTimeFormatter dateFormatter;

    public WeekFunction(String datePattern) {
        this.dateFormatter = StringUtils.isEmpty(datePattern) ? Constants.DEFAULT_DATETIME_FORMATTER : DateTimeFormatter.ofPattern(datePattern);
    }

    @Override
    public String getName() {
        return SqlFunctions.WEEK.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs[0] == null) {
            return null;
        }
        return this.week(LocalDateTime.parse(varargs[0], this.dateFormatter));
    }

    private String week(LocalDateTime datetime) {
        return String.valueOf(datetime.toLocalDate().get(WeekFields.ISO.weekOfYear()) + 1);
    }
}

