/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.mask;

import com.oceanbase.tools.loaddump.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class MaskShowFirstNFunction
extends AbstractBuiltinFunction {
    private final String upperMask;
    private final String lowerMask;
    private final String numMask;
    private final int firstN;

    public MaskShowFirstNFunction() {
        this("X", "x", "n", 0);
    }

    public MaskShowFirstNFunction(String upperMask) {
        this(upperMask, "x", "n", 0);
    }

    public MaskShowFirstNFunction(String upperMask, String lowerMask) {
        this(upperMask, lowerMask, "n", 0);
    }

    public MaskShowFirstNFunction(String upperMask, String lowerMask, String numMask) {
        this(upperMask, lowerMask, numMask, 0);
    }

    public MaskShowFirstNFunction(String upperMask, String lowerMask, String numMask, int firstN) {
        this.upperMask = upperMask;
        this.lowerMask = lowerMask;
        this.numMask = numMask;
        this.firstN = firstN;
    }

    @Override
    public String getName() {
        return SqlFunctions.MASK_SHOW_FIRST_N_FUNCTION.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return this.maskShowFirstN(varargs == null ? null : varargs[0]);
    }

    private String maskShowFirstN(String origin) {
        if (StringUtils.isEmpty(origin) || this.firstN < 0) {
            return origin;
        }
        StringBuilder sb = new StringBuilder(origin.length());
        int n = Math.min(this.firstN, origin.length());
        sb.append(origin, 0, n);
        for (int i = n; i < origin.length(); ++i) {
            char c = origin.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append(this.upperMask);
                continue;
            }
            if (Character.isLowerCase(c)) {
                sb.append(this.lowerMask);
                continue;
            }
            if (Character.isDigit(c)) {
                sb.append(this.numMask);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

