/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.string;

import com.oceanbase.tools.loaddump.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import java.util.Arrays;

public class RtrimFunction
extends AbstractBuiltinFunction {
    private String trimString = " ";

    public RtrimFunction() {
        this(" ");
    }

    public RtrimFunction(String trimString) {
        this.trimString = trimString;
    }

    @Override
    public String getName() {
        return SqlFunctions.RTRIM.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return varargs == null ? null : this.rtrim(varargs[0]);
    }

    private String rtrim(String value) {
        char key;
        int endIndex;
        if (value == null) {
            return null;
        }
        if (this.trimString == null) {
            this.trimString = " ";
        }
        char[] trimSet = this.trimString.toCharArray();
        for (endIndex = value.length(); endIndex > 0 && Arrays.binarySearch(trimSet, key = value.charAt(endIndex - 1)) >= 0; --endIndex) {
        }
        return value.substring(0, endIndex);
    }

    public void setTrimString(String trimString) {
        this.trimString = trimString;
    }
}

