/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.visitor;

import com.oceanbase.tools.loaddump.antlr4.ControlLexer;
import com.oceanbase.tools.loaddump.antlr4.ControlParser;
import com.oceanbase.tools.loaddump.antlr4.ControlParserBaseVisitor;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.function.SqlFunction;
import com.oceanbase.tools.loaddump.function.advance.SearchCaseFunction;
import com.oceanbase.tools.loaddump.function.advance.SimpleCaseFunction;
import com.oceanbase.tools.loaddump.function.context.ControlContext;
import com.oceanbase.tools.loaddump.function.context.ControlDescription;
import com.oceanbase.tools.loaddump.function.crypto.SM3DigestFunction;
import com.oceanbase.tools.loaddump.function.crypto.SM4DecryptFunction;
import com.oceanbase.tools.loaddump.function.crypto.SM4EncryptFunction;
import com.oceanbase.tools.loaddump.function.date.DateAddFunction;
import com.oceanbase.tools.loaddump.function.date.DateTruncFunction;
import com.oceanbase.tools.loaddump.function.date.DayOfMonthFunction;
import com.oceanbase.tools.loaddump.function.date.DayOfWeekFunction;
import com.oceanbase.tools.loaddump.function.date.DayOfYearFunction;
import com.oceanbase.tools.loaddump.function.date.HourFunction;
import com.oceanbase.tools.loaddump.function.date.MinuteFunction;
import com.oceanbase.tools.loaddump.function.date.MonthFunction;
import com.oceanbase.tools.loaddump.function.date.SysDateFunction;
import com.oceanbase.tools.loaddump.function.date.SysTimestampFunction;
import com.oceanbase.tools.loaddump.function.date.TimestampAddFunction;
import com.oceanbase.tools.loaddump.function.date.TimestampFormatFunction;
import com.oceanbase.tools.loaddump.function.date.TimestampTruncFunction;
import com.oceanbase.tools.loaddump.function.date.ToTimestampFunction;
import com.oceanbase.tools.loaddump.function.date.WeekFunction;
import com.oceanbase.tools.loaddump.function.date.YearFunction;
import com.oceanbase.tools.loaddump.function.enums.Languages;
import com.oceanbase.tools.loaddump.function.expression.Expression;
import com.oceanbase.tools.loaddump.function.expression.IsExpression;
import com.oceanbase.tools.loaddump.function.expression.IsNotExpression;
import com.oceanbase.tools.loaddump.function.expression.LogicalExpression;
import com.oceanbase.tools.loaddump.function.expression.NotExpression;
import com.oceanbase.tools.loaddump.function.expression.PredicateExpression;
import com.oceanbase.tools.loaddump.function.generation.Constant;
import com.oceanbase.tools.loaddump.function.generation.sequence.DatabaseSequence;
import com.oceanbase.tools.loaddump.function.generation.sequence.MemorySequence;
import com.oceanbase.tools.loaddump.function.mask.MaskFirstNFunction;
import com.oceanbase.tools.loaddump.function.mask.MaskFunction;
import com.oceanbase.tools.loaddump.function.mask.MaskLastNFunction;
import com.oceanbase.tools.loaddump.function.mask.MaskShowFirstNFunction;
import com.oceanbase.tools.loaddump.function.mask.MaskShowLastNFunction;
import com.oceanbase.tools.loaddump.function.none.ConstantFunction;
import com.oceanbase.tools.loaddump.function.none.NoneFunction;
import com.oceanbase.tools.loaddump.function.number.MathemFunction;
import com.oceanbase.tools.loaddump.function.number.NanvlFunction;
import com.oceanbase.tools.loaddump.function.number.TruncFunction;
import com.oceanbase.tools.loaddump.function.predicate.BinCompPredicate;
import com.oceanbase.tools.loaddump.function.predicate.InPredicate;
import com.oceanbase.tools.loaddump.function.predicate.IsNotNullPredicate;
import com.oceanbase.tools.loaddump.function.predicate.IsNullPredicate;
import com.oceanbase.tools.loaddump.function.predicate.NotInPredicate;
import com.oceanbase.tools.loaddump.function.string.AsciiFunction;
import com.oceanbase.tools.loaddump.function.string.ChrFunction;
import com.oceanbase.tools.loaddump.function.string.ConcatFunction;
import com.oceanbase.tools.loaddump.function.string.ConvertFunction;
import com.oceanbase.tools.loaddump.function.string.HexToRawFunction;
import com.oceanbase.tools.loaddump.function.string.LengthFunction;
import com.oceanbase.tools.loaddump.function.string.LowerFunction;
import com.oceanbase.tools.loaddump.function.string.LpadFunction;
import com.oceanbase.tools.loaddump.function.string.LpadbFunction;
import com.oceanbase.tools.loaddump.function.string.LtrimFunction;
import com.oceanbase.tools.loaddump.function.string.NchrFunction;
import com.oceanbase.tools.loaddump.function.string.NvlFunction;
import com.oceanbase.tools.loaddump.function.string.RawToHexFunction;
import com.oceanbase.tools.loaddump.function.string.ReplaceFunction;
import com.oceanbase.tools.loaddump.function.string.ReverseFunction;
import com.oceanbase.tools.loaddump.function.string.RpadFunction;
import com.oceanbase.tools.loaddump.function.string.RpadbFunction;
import com.oceanbase.tools.loaddump.function.string.RtrimFunction;
import com.oceanbase.tools.loaddump.function.string.SubstrFunction;
import com.oceanbase.tools.loaddump.function.string.TrimFunction;
import com.oceanbase.tools.loaddump.function.string.UpperFunction;
import com.oceanbase.tools.loaddump.function.visitor.DefaultSyntaxErrorListener;
import com.oceanbase.tools.loaddump.function.visitor.SyntaxException;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultControlParserVisitor
extends ControlParserBaseVisitor<Integer> {
    private static final Logger log = LoggerFactory.getLogger(DefaultControlParserVisitor.class);
    private static final Integer DEFAULT_RETURN_CODE = 0;
    private static final Map<String, ScriptEngine> SCRIPT_ENGINE_CACHE = new HashMap<String, ScriptEngine>();
    private final Map<String, String> constantDeclarations = new HashMap<String, String>();
    private final ControlContext controlContext;
    private final AtomicInteger columnIdProducer;
    private final Stack<SqlFunction> callStacks = new Stack();
    private final Stack<Expression> expressions = new Stack();
    private final Stack<Predicate<String>> predicates = new Stack();
    private final ServerMode serverMode;

    private DefaultControlParserVisitor(ServerMode serverMode) {
        this.controlContext = new ControlContext();
        this.columnIdProducer = new AtomicInteger(0);
        this.serverMode = serverMode;
    }

    public static ControlContext doParse(String fileName, String stmt, ServerMode serverMode) {
        ControlLexer lexer = new ControlLexer((CharStream)CharStreams.fromString((String)stmt));
        ControlParser parser = new ControlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new DefaultSyntaxErrorListener(fileName));
        ControlParser.ControlDefineContext controlDefineContext = parser.controlDefine();
        DefaultControlParserVisitor visitor = new DefaultControlParserVisitor(serverMode);
        controlDefineContext.accept(visitor);
        return visitor.getControlContext();
    }

    public static ControlContext doParse(File file, ServerMode serverMode) throws Exception {
        try (FileInputStream fis = new FileInputStream(file);){
            ControlContext controlContext = DefaultControlParserVisitor.doParse(file.getName(), fis, serverMode);
            return controlContext;
        }
    }

    /*
     * Exception decompiling
     */
    public static ControlContext doParse(String fileName, InputStream is, ServerMode serverMode) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Integer visitLangDefine(ControlParser.LangDefineContext ctx) {
        if (ctx.getToken(33, 0) != null) {
            this.getControlContext().setLanguages(Languages.SQL);
        }
        if (ctx.getToken(34, 0) != null) {
            this.getControlContext().setLanguages(Languages.JAVA);
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitServerDefine(ControlParser.ServerDefineContext ctx) {
        if (ctx.getToken(37, 0) != null) {
            this.getControlContext().setOracle(false);
        }
        if (ctx.getToken(38, 0) != null) {
            this.getControlContext().setOracle(true);
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitDeclarationDefine(ControlParser.DeclarationDefineContext ctx) {
        String key = ctx.getChild(1).getText();
        String value = ctx.getChild(3).getText();
        this.constantDeclarations.put(key, value.substring(1, value.length() - 1));
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitFieldDefine(ControlParser.FieldDefineContext ctx) {
        return (Integer)super.visitFieldDefine(ctx);
    }

    @Override
    public Integer visitFieldDescription(ControlParser.FieldDescriptionContext ctx) {
        int columnId = this.getColumnIdProducer().get();
        String columnName = ctx.getChild(0).getText();
        columnName = DBUtils.extractObjectName(columnName, this.serverMode);
        this.getControlContext().add(new ControlDescription(columnId, columnName));
        super.visitFieldDescription(ctx);
        this.getColumnIdProducer().getAndIncrement();
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitPositionDefine(ControlParser.PositionDefineContext ctx) {
        ControlParser.DecimalLiteralContext arg1 = (ControlParser.DecimalLiteralContext)ctx.getChild(ControlParser.DecimalLiteralContext.class, 0);
        ControlParser.DecimalLiteralContext arg2 = (ControlParser.DecimalLiteralContext)ctx.getChild(ControlParser.DecimalLiteralContext.class, 1);
        ControlDescription cDesc = this.getCurrentControlDescription();
        boolean isFiller = "_FILLER".equalsIgnoreCase(cDesc.getColumnName());
        if (arg2 == null) {
            cDesc.setOffset(new Offset((int)this.visitInt((ParseTree)arg1), isFiller));
        } else {
            cDesc.setOffset(new Offset(this.visitInt((ParseTree)arg1), this.visitInt((ParseTree)arg2), isFiller));
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitFunctionDescription(ControlParser.FunctionDescriptionContext ctx) {
        this.visit((ParseTree)ctx.getRuleContext(ControlParser.FunctionCallContext.class, 0));
        while (!this.getCallStacks().isEmpty()) {
            this.getCurrentControlDescription().add(this.execFuncPop());
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitMapDefine(ControlParser.MapDefineContext ctx) {
        ControlParser.DecimalLiteralContext mappedIndex = (ControlParser.DecimalLiteralContext)ctx.getChild(ControlParser.DecimalLiteralContext.class, 0);
        this.getCurrentControlDescription().setMappedIndex(this.visitInt((ParseTree)mappedIndex));
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitSequenceDefine(ControlParser.SequenceDefineContext ctx) {
        MemorySequence memorySequence = ctx.incr == null ? new MemorySequence(this.visitLong((ParseTree)ctx.initial)) : new MemorySequence(this.visitLong((ParseTree)ctx.initial), this.visitLong((ParseTree)ctx.incr));
        this.getCurrentControlDescription().setGeneratedDefine(memorySequence);
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitDbSequenceDefine(ControlParser.DbSequenceDefineContext ctx) {
        DatabaseSequence dbSequence = new DatabaseSequence(this.visitString((ParseTree)ctx.name));
        this.getCurrentControlDescription().setGeneratedDefine(dbSequence);
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitNoneFunction(ControlParser.NoneFunctionContext ctx) {
        this.execFuncPush(NoneFunction.newInstance());
        log.debug("visitNoneFunction => none");
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitTrimFunction(ControlParser.TrimFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        this.execFuncPush(TrimFunction.newInstance());
        log.debug("visitTrimFunction => trim({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitAsciiFunction(ControlParser.AsciiFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        this.execFuncPush(AsciiFunction.newInstance());
        log.debug("visitAsciiFunction => ascii({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitChrFunction(ControlParser.ChrFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        this.execFuncPush(ChrFunction.newInstance());
        log.debug("visitChrFunction => chr({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitNchrFunction(ControlParser.NchrFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        this.execFuncPush(NchrFunction.newInstance());
        log.debug("visitNchrFunction => nchr({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitRawToHexFunction(ControlParser.RawToHexFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        this.execFuncPush(RawToHexFunction.newInstance());
        log.debug("visitRawToHexFunction => rawtohex({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitHexToRawFunction(ControlParser.HexToRawFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        this.execFuncPush(HexToRawFunction.newInstance());
        log.debug("visitHexToRawFunction => hextoraw({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitLowerFunction(ControlParser.LowerFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        this.execFuncPush(LowerFunction.newInstance());
        log.debug("visitLowerFunction => lower({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitUpperFunction(ControlParser.UpperFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        this.execFuncPush(UpperFunction.newInstance());
        log.debug("visitUpperFunction => upper({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitLtrimFunction(ControlParser.LtrimFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        if (arg1 == null) {
            this.execFuncPush(new LtrimFunction());
            log.debug("visitLtrimFunction => ltrim({})", (Object)arg0.getText());
        } else {
            this.execFuncPush(new LtrimFunction(this.visitString((ParseTree)arg1)));
            log.debug("visitLtrimFunction => ltrim({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitRtrimFunction(ControlParser.RtrimFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        if (arg1 == null) {
            this.execFuncPush(new RtrimFunction());
            log.debug("visitRtrimFunction => rtrim({})", (Object)arg0.getText());
        } else {
            this.execFuncPush(new RtrimFunction(this.visitString((ParseTree)arg1)));
            log.debug("visitRtrimFunction => rtrim({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitLengthFunction(ControlParser.LengthFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        LengthFunction lengthFunction = new LengthFunction(this.getControlContext().isOracle());
        this.execFuncPush(lengthFunction);
        log.debug("visitLengthFunction => length({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitConstantFunction(ControlParser.ConstantFunctionContext ctx) {
        ControlParser.ConstantArgContext arg0 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        this.execFuncPush(new ConstantFunction(this.visitString((ParseTree)arg0)));
        this.getCurrentControlDescription().setGeneratedDefine(new Constant(this.visitString((ParseTree)arg0)));
        log.debug("visitConstantFunction => constant({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitSysDateFunction(ControlParser.SysDateFunctionContext ctx) {
        this.execFuncPush(SysDateFunction.newInstance());
        log.debug("visitSysDateFunction => systdate");
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitSysTmFunction(ControlParser.SysTmFunctionContext ctx) {
        this.execFuncPush(SysTimestampFunction.newInstance());
        log.debug("visitSysTmFunction => systimestamp");
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitNvlFunction(ControlParser.NvlFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        if (arg1.getToken(64, 0) != null) {
            this.execFuncPush(new NvlFunction(null));
        } else {
            this.execFuncPush(new NvlFunction(this.visitString((ParseTree)arg1)));
        }
        log.debug("visitNvlFunction => nvl({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitNanvlFunction(ControlParser.NanvlFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        if (arg1.getToken(64, 0) != null) {
            this.execFuncPush(new NanvlFunction(null));
        } else {
            this.execFuncPush(new NanvlFunction(this.visitString((ParseTree)arg1)));
        }
        log.debug("visitNanvlFunction => nanvl({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitTruncFunction(ControlParser.TruncFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        if (arg1 == null) {
            log.debug("visitTruncFunction => trunc({})", (Object)arg0.getText());
            this.execFuncPush(new TruncFunction(0));
        } else {
            int decimal = this.visitInt((ParseTree)arg1);
            log.debug("visitTruncFunction => trunc({}, {})", (Object)arg0.getText(), (Object)decimal);
            this.execFuncPush(new TruncFunction(decimal));
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitToTmsFunction(ControlParser.ToTmsFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        if (arg2 == null) {
            this.execFuncPush(new ToTimestampFunction(this.visitString((ParseTree)arg1)));
            log.debug("visitToTmsFunction => to_timestamp({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else {
            this.execFuncPush(new ToTimestampFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitToTmsFunction => to_timestamp({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitDateAddFunction(ControlParser.DateAddFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        ControlParser.ConstantArgContext arg3 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 2);
        this.execFuncPush(new DateAddFunction(Integer.parseInt(this.visitString((ParseTree)arg1)), this.visitString((ParseTree)arg2), arg3 == null ? null : this.visitString((ParseTree)arg3)));
        log.debug("visitDateAddFunction => date_add({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitTimestampAddFunction(ControlParser.TimestampAddFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        ControlParser.ConstantArgContext arg3 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 2);
        this.execFuncPush(new TimestampAddFunction(Integer.parseInt(this.visitString((ParseTree)arg1)), this.visitString((ParseTree)arg2), arg3 == null ? null : this.visitString((ParseTree)arg3)));
        log.debug("visitTimestampAddFunction => timestamp_add({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitDateTruncFunction(ControlParser.DateTruncFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        this.execFuncPush(new DateTruncFunction(this.visitString((ParseTree)arg1), arg2 == null ? null : this.visitString((ParseTree)arg2)));
        log.debug("visitDateTruncFunction => date_trunc({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitTimestampTruncFunction(ControlParser.TimestampTruncFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        this.execFuncPush(new TimestampTruncFunction(this.visitString((ParseTree)arg1), arg2 == null ? null : this.visitString((ParseTree)arg2)));
        log.debug("visitTimestampFunction => timestamp_trunc({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitYearFunction(ControlParser.YearFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        this.execFuncPush(new YearFunction(arg1 == null ? null : this.visitString((ParseTree)arg1)));
        log.debug("visitYearFunction => year({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitMonthFunction(ControlParser.MonthFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        this.execFuncPush(new MonthFunction(arg1 == null ? null : this.visitString((ParseTree)arg1)));
        log.debug("visitMonthFunction => month({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitHourFunction(ControlParser.HourFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        this.execFuncPush(new HourFunction(arg1 == null ? null : this.visitString((ParseTree)arg1)));
        log.debug("visitHourFunction => hour({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitMinuteFunction(ControlParser.MinuteFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        this.execFuncPush(new MinuteFunction(arg1 == null ? null : this.visitString((ParseTree)arg1)));
        log.debug("visitMinuteFunction => minute({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitWeekFunction(ControlParser.WeekFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        this.execFuncPush(new WeekFunction(arg1 == null ? null : this.visitString((ParseTree)arg1)));
        log.debug("visitWeekFunction => week({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitDayOfMonthFunction(ControlParser.DayOfMonthFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        this.execFuncPush(new DayOfMonthFunction(arg1 == null ? null : this.visitString((ParseTree)arg1)));
        log.debug("visitDayOfMonthFunction => day_of_month({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitDayOfYearFunction(ControlParser.DayOfYearFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        this.execFuncPush(new DayOfYearFunction(arg1 == null ? null : this.visitString((ParseTree)arg1)));
        log.debug("visitDayOfYearFunction => day_of_year({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitDayOfWeekFunction(ControlParser.DayOfWeekFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        this.execFuncPush(new DayOfWeekFunction(arg1 == null ? null : this.visitString((ParseTree)arg1)));
        log.debug("visitDayOfWeekFunction => day_of_week({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitLpadFunction(ControlParser.LpadFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        if (arg2 == null) {
            this.execFuncPush(new LpadFunction(this.visitInt((ParseTree)arg1)));
            log.debug("visitLpadFunction => lpad({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else {
            this.execFuncPush(new LpadFunction(this.visitInt((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitLpadFunction => lpad({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitRpadFunction(ControlParser.RpadFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        if (arg2 == null) {
            this.execFuncPush(new RpadFunction(this.visitInt((ParseTree)arg1)));
            log.debug("visitRpadFunction => rpad({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else {
            this.execFuncPush(new RpadFunction(this.visitInt((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitRpadFunction => rpad({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitConcatFunction(ControlParser.ConcatFunctionContext ctx) {
        ConcatFunction concat = new ConcatFunction();
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getRuleContext(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        while (!this.getCallStacks().isEmpty()) {
            concat.getFunc1().add(this.execFuncPop());
        }
        ControlParser.FunctionArgContext arg1 = (ControlParser.FunctionArgContext)ctx.getRuleContext(ControlParser.FunctionArgContext.class, 1);
        this.visit((ParseTree)arg1);
        while (!this.getCallStacks().isEmpty()) {
            concat.getFunc2().add(this.execFuncPop());
        }
        this.execFuncPush(concat);
        log.debug("visitConcatFunction => concat({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitLpadbFunction(ControlParser.LpadbFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getRuleContext(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getRuleContext(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getRuleContext(ControlParser.ConstantArgContext.class, 1);
        if (arg2 == null) {
            this.execFuncPush(new LpadbFunction(this.visitInt((ParseTree)arg1)));
            log.debug("visitLpadbFunction => lpadb({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else {
            this.execFuncPush(new LpadbFunction(this.visitInt((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitLpadbFunction => lpadb({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitRpadbFunction(ControlParser.RpadbFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getRuleContext(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getRuleContext(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getRuleContext(ControlParser.ConstantArgContext.class, 1);
        if (arg2 == null) {
            this.execFuncPush(new RpadbFunction(this.visitInt((ParseTree)arg1)));
            log.debug("visitRpadbFunction => rpadb({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else {
            this.execFuncPush(new RpadbFunction(this.visitInt((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitRpadbFunction => rpadb({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitConvertFunction(ControlParser.ConvertFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getRuleContext(ControlParser.FunctionArgContext.class, 0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getRuleContext(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getRuleContext(ControlParser.ConstantArgContext.class, 1);
        if (arg2 == null) {
            this.execFuncPush(new ConvertFunction(this.visitString((ParseTree)arg1)));
            log.debug("visitConvertFunction => convert({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else {
            this.execFuncPush(new ConvertFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitConvertFunction => convert({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitTmsfmtFunction(ControlParser.TmsfmtFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        ControlParser.ConstantArgContext arg3 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 2);
        if (arg3 == null) {
            this.execFuncPush(new TimestampFormatFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitTmsfmtFunction => tmsfmt({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        } else {
            this.execFuncPush(new TimestampFormatFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2), this.visitString((ParseTree)arg3)));
            log.debug("visitTmsfmtFunction => tmsfmt({},{},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText(), arg3.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitReplaceFunction(ControlParser.ReplaceFunctionContext ctx) {
        ReplaceFunction replaceFunc = new ReplaceFunction();
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getRuleContext(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        while (!this.getCallStacks().isEmpty()) {
            replaceFunc.getOriginFunc().add(this.execFuncPop());
        }
        ControlParser.FunctionArgContext arg1 = (ControlParser.FunctionArgContext)ctx.getRuleContext(ControlParser.FunctionArgContext.class, 1);
        this.visit((ParseTree)arg1);
        while (!this.getCallStacks().isEmpty()) {
            replaceFunc.getSearchFunc().add(this.execFuncPop());
        }
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        if (arg2 == null) {
            this.execFuncPush(replaceFunc);
            log.debug("visitReplaceFunction => replace({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else {
            String replacement = arg2.getToken(64, 0) == null ? this.visitString((ParseTree)arg2) : null;
            replaceFunc.setReplacement(replacement);
            this.execFuncPush(replaceFunc);
            log.debug("visitReplaceFunction => replace({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitReverseFunction(ControlParser.ReverseFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        this.execFuncPush(ReverseFunction.newInstance());
        log.debug("visitReverseFunction => reverse({})", (Object)arg0.getText());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitSubstrFunction(ControlParser.SubstrFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        int minus = ctx.getToken(11, 0) == null ? 1 : -1;
        int startPosition = this.visitInt((ParseTree)arg1) * minus;
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        if (arg2 == null) {
            this.execFuncPush(new SubstrFunction(startPosition));
            log.debug("visitSubstrFunction => substr({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else {
            this.execFuncPush(new SubstrFunction(startPosition, this.visitInt((ParseTree)arg2)));
            log.debug("visitSubstrFunction => substr({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitSubstringFunction(ControlParser.SubstringFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        int minus = ctx.getToken(11, 0) == null ? 1 : -1;
        int startPosition = this.visitInt((ParseTree)arg1) * minus;
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        if (arg2 == null) {
            this.execFuncPush(new SubstrFunction(startPosition));
            log.debug("visitSubstringFunction => substring({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else {
            this.execFuncPush(new SubstrFunction(startPosition, this.visitInt((ParseTree)arg2)));
            log.debug("visitSubstringFunction => substring({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitMaskFunction(ControlParser.MaskFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        ControlParser.ConstantArgContext arg3 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 2);
        if (arg1 == null) {
            this.execFuncPush(new MaskFunction());
            log.debug("visitMaskFunction => mask({})", (Object)arg0.getText());
        } else if (arg2 == null) {
            this.execFuncPush(new MaskFunction(this.visitString((ParseTree)arg1)));
            log.debug("visitMaskFunction => mask({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else if (arg3 == null) {
            this.execFuncPush(new MaskFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitMaskFunction => mask({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        } else {
            this.execFuncPush(new MaskFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2), this.visitString((ParseTree)arg3)));
            log.debug("visitMaskFunction => mask({},{},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText(), arg3.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitMaskFirstNFunction(ControlParser.MaskFirstNFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        ControlParser.ConstantArgContext arg3 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 2);
        ControlParser.ConstantArgContext arg4 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 3);
        if (arg1 == null) {
            this.execFuncPush(new MaskFirstNFunction());
            log.debug("visitMaskFirstNFunction => mask({})", (Object)arg0.getText());
        } else if (arg2 == null) {
            this.execFuncPush(new MaskFirstNFunction(this.visitString((ParseTree)arg1)));
            log.debug("visitMaskFirstNFunction => mask({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else if (arg3 == null) {
            this.execFuncPush(new MaskFirstNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitMaskFirstNFunction => mask({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        } else if (arg4 == null) {
            this.execFuncPush(new MaskFirstNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2), this.visitString((ParseTree)arg3)));
            log.debug("visitMaskFirstNFunction => mask({},{},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText(), arg3.getText()});
        } else {
            this.execFuncPush(new MaskFirstNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2), this.visitString((ParseTree)arg3), this.visitInt((ParseTree)arg4)));
            log.debug("visitMaskFirstNFunction => mask({},{},{},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText(), arg3.getText(), arg4.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitMaskLastNFunction(ControlParser.MaskLastNFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        ControlParser.ConstantArgContext arg3 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 2);
        ControlParser.ConstantArgContext arg4 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 3);
        if (arg1 == null) {
            this.execFuncPush(new MaskLastNFunction());
            log.debug("visitMaskLastNFunction => mask({})", (Object)arg0.getText());
        } else if (arg2 == null) {
            this.execFuncPush(new MaskLastNFunction(this.visitString((ParseTree)arg1)));
            log.debug("visitMaskLastNFunction => mask({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else if (arg3 == null) {
            this.execFuncPush(new MaskLastNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitMaskLastNFunction => mask({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        } else if (arg4 == null) {
            this.execFuncPush(new MaskLastNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2), this.visitString((ParseTree)arg3)));
            log.debug("visitMaskLastNFunction => mask({},{},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText(), arg3.getText()});
        } else {
            this.execFuncPush(new MaskLastNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2), this.visitString((ParseTree)arg3), this.visitInt((ParseTree)arg4)));
            log.debug("visitMaskLastNFunction => mask({},{},{},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText(), arg3.getText(), arg4.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitMaskShowFirstNFunction(ControlParser.MaskShowFirstNFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        ControlParser.ConstantArgContext arg3 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 2);
        ControlParser.ConstantArgContext arg4 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 3);
        if (arg1 == null) {
            this.execFuncPush(new MaskShowFirstNFunction());
            log.debug("visitMaskShowFirstNFunction => mask({})", (Object)arg0.getText());
        } else if (arg2 == null) {
            this.execFuncPush(new MaskShowFirstNFunction(this.visitString((ParseTree)arg1)));
            log.debug("visitMaskShowFirstNFunction => mask({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else if (arg3 == null) {
            this.execFuncPush(new MaskShowFirstNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitMaskShowFirstNFunction => mask({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        } else if (arg4 == null) {
            this.execFuncPush(new MaskShowFirstNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2), this.visitString((ParseTree)arg3)));
            log.debug("visitMaskShowFirstNFunction => mask({},{},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText(), arg3.getText()});
        } else {
            this.execFuncPush(new MaskShowFirstNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2), this.visitString((ParseTree)arg3), this.visitInt((ParseTree)arg4)));
            log.debug("visitMaskShowFirstNFunction => mask({},{},{},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText(), arg3.getText(), arg4.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitMaskShowLastNFunction(ControlParser.MaskShowLastNFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        ControlParser.ConstantArgContext arg3 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 2);
        ControlParser.ConstantArgContext arg4 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 3);
        if (arg1 == null) {
            this.execFuncPush(new MaskShowLastNFunction());
            log.debug("visitMaskShowLastNFunction => mask({})", (Object)arg0.getText());
        } else if (arg2 == null) {
            this.execFuncPush(new MaskShowLastNFunction(this.visitString((ParseTree)arg1)));
            log.debug("visitMaskShowLastNFunction => mask({},{})", (Object)arg0.getText(), (Object)arg1.getText());
        } else if (arg3 == null) {
            this.execFuncPush(new MaskShowLastNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2)));
            log.debug("visitMaskShowLastNFunction => mask({},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText()});
        } else if (arg4 == null) {
            this.execFuncPush(new MaskShowLastNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2), this.visitString((ParseTree)arg3)));
            log.debug("visitMaskShowLastNFunction => mask({},{},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText(), arg3.getText()});
        } else {
            this.execFuncPush(new MaskShowLastNFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2), this.visitString((ParseTree)arg3), this.visitInt((ParseTree)arg4)));
            log.debug("visitMaskShowLastNFunction => mask({},{},{},{},{})", new Object[]{arg0.getText(), arg1.getText(), arg2.getText(), arg3.getText(), arg4.getText()});
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitSm4EncryptFunction(ControlParser.Sm4EncryptFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        if (arg2 == null) {
            this.execFuncPush(new SM4EncryptFunction(this.visitString((ParseTree)arg1)));
        } else {
            this.execFuncPush(new SM4EncryptFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2)));
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitSm4DecryptFunction(ControlParser.Sm4DecryptFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        ControlParser.ConstantArgContext arg2 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 1);
        if (arg2 == null) {
            this.execFuncPush(new SM4DecryptFunction(this.visitString((ParseTree)arg1)));
        } else {
            this.execFuncPush(new SM4DecryptFunction(this.visitString((ParseTree)arg1), this.visitString((ParseTree)arg2)));
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitSm3DigestFunction(ControlParser.Sm3DigestFunctionContext ctx) {
        ControlParser.FunctionArgContext arg0 = (ControlParser.FunctionArgContext)ctx.getChild(ControlParser.FunctionArgContext.class, 0);
        this.visit((ParseTree)arg0);
        ControlParser.ConstantArgContext arg1 = (ControlParser.ConstantArgContext)ctx.getChild(ControlParser.ConstantArgContext.class, 0);
        if (arg1 == null) {
            this.execFuncPush(new SM3DigestFunction());
        } else {
            this.execFuncPush(new SM3DigestFunction(this.visitString((ParseTree)arg1)));
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitSimpleCaseFunctionCall(ControlParser.SimpleCaseFunctionCallContext ctx) {
        this.visit(ctx.getChild(ControlParser.PredicateExpressionContext.class, 0));
        SimpleCaseFunction simpleCase = new SimpleCaseFunction();
        while (!this.getCallStacks().isEmpty()) {
            simpleCase.getCallStacks().add(this.getCallStacks().pop());
        }
        for (ControlParser.CaseFuncAlternativeContext when : ctx.getRuleContexts(ControlParser.CaseFuncAlternativeContext.class)) {
            this.visit((ParseTree)when.consequent);
            String conditionArg = this.visitString((ParseTree)when.condition);
            SimpleCaseFunction.SimpleCaseFuncAlternative alternative = new SimpleCaseFunction.SimpleCaseFuncAlternative(conditionArg);
            while (!this.getCallStacks().isEmpty()) {
                alternative.getConsequentArg().add(this.getCallStacks().pop());
            }
            simpleCase.getCaseFuncAlternatives().add(alternative);
        }
        ControlParser.FunctionArgContext elseArgCtx = ctx.elseArg;
        if (elseArgCtx != null) {
            this.visit((ParseTree)elseArgCtx);
            SimpleCaseFunction.SimpleElseFuncAlternative alternative = new SimpleCaseFunction.SimpleElseFuncAlternative();
            while (!this.getCallStacks().isEmpty()) {
                alternative.getElseArg().add(this.getCallStacks().pop());
            }
            simpleCase.setElseFuncAlternative(alternative);
        }
        this.execFuncPush(simpleCase);
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitFunctionArg(ControlParser.FunctionArgContext ctx) {
        int childCount = ctx.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.visit(ctx.getChild(i));
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitSearchCaseFunctionCall(ControlParser.SearchCaseFunctionCallContext ctx) {
        SearchCaseFunction searchCase = new SearchCaseFunction();
        for (ControlParser.CaseFuncAlternativeContext when : ctx.getRuleContexts(ControlParser.CaseFuncAlternativeContext.class)) {
            this.visit((ParseTree)when.condition);
            SearchCaseFunction.SearchCaseFuncAlternative alternative = new SearchCaseFunction.SearchCaseFuncAlternative();
            alternative.setConditionArg(this.execExprPop());
            this.visit((ParseTree)when.consequent);
            while (!this.getCallStacks().isEmpty()) {
                alternative.getConsequentArg().add(this.execFuncPop());
            }
            searchCase.getCaseFuncAlternatives().add(alternative);
        }
        ControlParser.FunctionArgContext elseArgCtx = ctx.elseArg;
        if (elseArgCtx != null) {
            this.visit((ParseTree)elseArgCtx);
            SearchCaseFunction.SearchElseFuncAlternative alternative = new SearchCaseFunction.SearchElseFuncAlternative();
            while (!this.getCallStacks().isEmpty()) {
                alternative.getElseArg().add(this.execFuncPop());
            }
            searchCase.setElseFuncAlternative(alternative);
        }
        this.execFuncPush(searchCase);
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitConstantArg(ControlParser.ConstantArgContext ctx) {
        if (ctx.getToken(64, 0) != null) {
            this.execFuncPush(new ConstantFunction(null));
        } else {
            this.execFuncPush(new ConstantFunction(this.visitString((ParseTree)ctx)));
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitNotExpression(ControlParser.NotExpressionContext ctx) {
        NotExpression not = new NotExpression();
        while (!this.getCallStacks().isEmpty()) {
            not.getFuncs().add(this.execFuncPop());
        }
        this.visit(ctx.getChild(ControlParser.ExpressionContext.class, 0));
        while (!this.getExpressions().isEmpty()) {
            not.getExprs().add(this.execExprPop());
        }
        this.execExprPush(not);
        this.visit(ctx.getChild(ControlParser.ExpressionContext.class, 0));
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitLogicalExpression(ControlParser.LogicalExpressionContext ctx) {
        LogicalExpression logical = new LogicalExpression();
        while (!this.getCallStacks().isEmpty()) {
            logical.getFuncs().add(this.execFuncPop());
        }
        this.visit(ctx.getChild(ControlParser.ExpressionContext.class, 0));
        while (!this.getExpressions().isEmpty()) {
            logical.getLeftExprs().add(this.execExprPop());
        }
        logical.setLogicalOperator(((ControlParser.LogicalOperatorContext)ctx.getChild(ControlParser.LogicalOperatorContext.class, 0)).getText());
        this.visit(ctx.getChild(ControlParser.ExpressionContext.class, 1));
        while (!this.getExpressions().isEmpty()) {
            logical.getRightExprs().add(this.execExprPop());
        }
        this.execExprPush(logical);
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitIsExpression(ControlParser.IsExpressionContext ctx) {
        IsExpression is = null;
        is = ctx.getToken(63, 0) == null ? new IsExpression() : new IsNotExpression();
        while (!this.getCallStacks().isEmpty()) {
            is.getFuncs().add(this.execFuncPop());
        }
        is.setTestValue(ctx.testValue.getText());
        is.setPredicate(this.evalPredPop(ctx.getChild(ControlParser.PredicateContext.class, 0)));
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitPredicateExpression(ControlParser.PredicateExpressionContext ctx) {
        PredicateExpression predicate = new PredicateExpression();
        while (!this.getCallStacks().isEmpty()) {
            predicate.getFuncs().add(this.execFuncPop());
        }
        predicate.setPredicate(this.evalPredPop(ctx.getChild(ControlParser.PredicateContext.class, 0)));
        this.execExprPush(predicate);
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitInPredicate(ControlParser.InPredicateContext ctx) {
        ArrayList<SqlFunction> constantValues = new ArrayList<SqlFunction>();
        while (!this.getCallStacks().isEmpty()) {
            constantValues.add(this.execFuncPop());
        }
        InPredicate predicate = null;
        predicate = ctx.getToken(63, 0) == null ? new InPredicate() : new NotInPredicate();
        this.visit(ctx.getChild(ControlParser.PredicateContext.class, 0));
        while (!this.getCallStacks().isEmpty()) {
            predicate.getPredicate().add(this.execFuncPop());
        }
        for (ParserRuleContext ctx0 : ctx.getRuleContexts(ControlParser.ConstantArgContext.class)) {
            this.visit((ParseTree)ctx0);
        }
        while (!this.getCallStacks().isEmpty()) {
            predicate.getConstantArgs().add(this.execFuncPop());
        }
        this.execPredPush(predicate);
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitIsNullPredicate(ControlParser.IsNullPredicateContext ctx) {
        IsNullPredicate predicate = null;
        predicate = ctx.getToken(63, 0) == null ? new IsNullPredicate() : new IsNotNullPredicate();
        this.visit(ctx.getChild(ControlParser.PredicateContext.class, 0));
        while (!this.getCallStacks().isEmpty()) {
            predicate.getPredicate().add(this.execFuncPop());
        }
        this.execPredPush(predicate);
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitBinCompPredicate(ControlParser.BinCompPredicateContext ctx) {
        String oper = ((ControlParser.ComparisonOperatorContext)ctx.getChild(ControlParser.ComparisonOperatorContext.class, 0)).getText();
        BinCompPredicate predicate = new BinCompPredicate(oper);
        this.visit((ParseTree)ctx.left);
        while (!this.getCallStacks().isEmpty()) {
            predicate.getLeftPred().add(this.execFuncPop());
        }
        this.visit((ParseTree)ctx.right);
        while (!this.getCallStacks().isEmpty()) {
            predicate.getRightPred().add(this.execFuncPop());
        }
        this.execPredPush(predicate);
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitExprAtomPredicate(ControlParser.ExprAtomPredicateContext ctx) {
        ControlParser.MathOperatorExprAtomContext ctx3;
        ControlParser.FunctionCallExprAtomContext ctx2;
        ControlParser.ColumnNameExprAtomContext ctx1;
        ControlParser.ConstantArgExprAtomContext ctx0 = (ControlParser.ConstantArgExprAtomContext)ctx.getRuleContext(ControlParser.ConstantArgExprAtomContext.class, 0);
        if (ctx0 != null) {
            this.visit(ctx0.getChild(ControlParser.ConstantArgContext.class, 0));
        }
        if ((ctx1 = (ControlParser.ColumnNameExprAtomContext)ctx.getRuleContext(ControlParser.ColumnNameExprAtomContext.class, 0)) != null) {
            this.visit(ctx1.getChild(ControlParser.ColumnNameContext.class, 0));
        }
        if ((ctx2 = (ControlParser.FunctionCallExprAtomContext)ctx.getRuleContext(ControlParser.FunctionCallExprAtomContext.class, 0)) != null) {
            this.visit(ctx2.getChild(ControlParser.FunctionCallContext.class, 0));
        }
        if ((ctx3 = (ControlParser.MathOperatorExprAtomContext)ctx.getRuleContext(ControlParser.MathOperatorExprAtomContext.class, 0)) != null) {
            this.visit((ParseTree)ctx3);
        }
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitConstantArgExprAtom(ControlParser.ConstantArgExprAtomContext ctx) {
        this.execFuncPush(NoneFunction.newInstance());
        return DEFAULT_RETURN_CODE;
    }

    @Override
    public Integer visitMathOperatorExprAtom(ControlParser.MathOperatorExprAtomContext ctx) {
        String operator = ((ControlParser.MathOperatorContext)ctx.getChild(ControlParser.MathOperatorContext.class, 0)).getText();
        MathemFunction math = new MathemFunction(operator);
        int leftChildCount = ctx.left.getChildCount();
        for (int i = 0; i < leftChildCount; ++i) {
            this.visit(ctx.left.getChild(i));
        }
        while (!this.getCallStacks().isEmpty()) {
            math.getLeftExpr().add(this.execFuncPop());
        }
        int rightChildCount = ctx.right.getChildCount();
        for (int i = 0; i < rightChildCount; ++i) {
            this.visit(ctx.right.getChild(i));
        }
        while (!this.getCallStacks().isEmpty()) {
            math.getRightExpr().add(this.execFuncPop());
        }
        this.execFuncPush(math);
        return DEFAULT_RETURN_CODE;
    }

    public void execExprPush(Expression expr) {
        this.getExpressions().push(expr);
    }

    public void execFuncPush(SqlFunction func) {
        this.getCallStacks().push(func);
    }

    private void execPredPush(Predicate<String> predicate) {
        this.getPredicates().push(predicate);
    }

    public SqlFunction execFuncPop() {
        if (this.getCallStacks().isEmpty()) {
            return NoneFunction.newInstance();
        }
        return this.getCallStacks().pop();
    }

    public Expression execExprPop() {
        if (this.getExpressions().isEmpty()) {
            return null;
        }
        return this.getExpressions().pop();
    }

    public Predicate<String> execPredPop() {
        if (this.getPredicates().isEmpty()) {
            return null;
        }
        return this.getPredicates().pop();
    }

    public Predicate<String> evalPredPop(ParseTree tree) {
        this.visit(tree);
        if (this.getPredicates().isEmpty()) {
            return null;
        }
        return this.getPredicates().pop();
    }

    public SqlFunction evalFuncPop(ParseTree tree) {
        this.visit(tree);
        if (this.getCallStacks().isEmpty()) {
            return NoneFunction.newInstance();
        }
        return this.getCallStacks().pop();
    }

    public Expression evalExprPop(ParseTree tree) {
        this.visit(tree);
        if (this.getExpressions().isEmpty()) {
            return null;
        }
        return this.getExpressions().pop();
    }

    public Integer visitInt(ParseTree tree) {
        if (tree.getChild(0) instanceof ControlParser.ConstantRefLiteralContext) {
            return Integer.valueOf(this.visitConstantRef(tree.getChild(0)));
        }
        String text = tree.getText();
        if (text == null) {
            return null;
        }
        return Integer.valueOf(text);
    }

    public Long visitLong(ParseTree tree) {
        if (tree.getChild(0) instanceof ControlParser.ConstantRefLiteralContext) {
            return Long.valueOf(this.visitConstantRef(tree.getChild(0)));
        }
        String text = tree.getText();
        if (text == null) {
            return null;
        }
        return Long.valueOf(text);
    }

    public String visitString(ParseTree tree) {
        if (tree.getChild(0) instanceof ControlParser.ConstantRefLiteralContext) {
            return this.visitConstantRef(tree.getChild(0));
        }
        String text = tree.getText();
        if (text == null) {
            return text;
        }
        if (text.startsWith("'") && text.endsWith("'")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    private String visitConstantRef(ParseTree tree) {
        String text = tree.getChild(1).getText();
        if (text == null) {
            throw new SyntaxException("Invalid syntax of constant reference");
        }
        if (!this.constantDeclarations.containsKey(text)) {
            throw new SyntaxException("'" + text + "' has not been declared");
        }
        return this.constantDeclarations.get(text);
    }

    public ControlDescription getCurrentControlDescription() {
        int columnId = this.getColumnIdProducer().get();
        return this.getControlContext().getControlDescription(columnId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngine createLangScriptEngine(String language) {
        DefaultControlParserVisitor defaultControlParserVisitor = this;
        synchronized (defaultControlParserVisitor) {
            ScriptEngine cachedScriptEngine = SCRIPT_ENGINE_CACHE.get(language);
            if (cachedScriptEngine == null) {
                ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                cachedScriptEngine = scriptEngineManager.getEngineByName(language);
                SCRIPT_ENGINE_CACHE.putIfAbsent(language, cachedScriptEngine);
            }
            return cachedScriptEngine;
        }
    }

    public Map<String, String> getConstantDeclarations() {
        return this.constantDeclarations;
    }

    public ControlContext getControlContext() {
        return this.controlContext;
    }

    public AtomicInteger getColumnIdProducer() {
        return this.columnIdProducer;
    }

    public Stack<SqlFunction> getCallStacks() {
        return this.callStacks;
    }

    public Stack<Expression> getExpressions() {
        return this.expressions;
    }

    public Stack<Predicate<String>> getPredicates() {
        return this.predicates;
    }
}

