/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class BoundedRandomInputStream
extends InputStream {
    private final RandomAccessFile raf;
    private final long max;
    private long pos = 0L;
    private long mark = -1L;
    private boolean propagateClose = true;

    public BoundedRandomInputStream(RandomAccessFile raf) {
        this(raf, -1L);
    }

    public BoundedRandomInputStream(RandomAccessFile raf, long size) {
        this.max = size;
        this.raf = raf;
    }

    @Override
    public int read() throws IOException {
        if (this.max >= 0L && this.pos >= this.max) {
            return -1;
        }
        int result = this.raf.read();
        ++this.pos;
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.max >= 0L && this.pos >= this.max) {
            return -1;
        }
        long maxRead = this.max >= 0L ? Math.min((long)len, this.max - this.pos) : (long)len;
        int bytesRead = this.raf.read(b, off, (int)maxRead);
        if (bytesRead == -1) {
            return -1;
        }
        this.pos += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long toSkip = this.max >= 0L ? Math.min(n, this.max - this.pos) : n;
        this.pos += toSkip;
        this.raf.seek(this.pos);
        return toSkip;
    }

    @Override
    public int available() throws IOException {
        if (this.max >= 0L && this.pos >= this.max) {
            return 0;
        }
        return (int)(this.max - this.raf.getFilePointer());
    }

    public String toString() {
        return this.raf.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.propagateClose) {
            this.raf.close();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.pos = this.mark;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public boolean isPropagateClose() {
        return this.propagateClose;
    }

    public void setPropagateClose(boolean propagateClose) {
        this.propagateClose = propagateClose;
    }
}

